/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.ensemble.WeightedBinaryEnsemble;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Cleaned up javadoc a little bit with code annotations.", "Otherwise, looks fine."})
public class BinaryBaggingLearner<InputType>
extends AbstractAnytimeBatchLearner<Collection<? extends InputOutputPair<? extends InputType, Boolean>>, WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>>>
implements Randomized,
BatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>>> {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> learner;
    protected Random random;
    protected transient WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> ensemble;
    protected transient ArrayList<InputOutputPair<? extends InputType, Boolean>> dataList;

    public BinaryBaggingLearner() {
        this(null);
    }

    public BinaryBaggingLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> learner) {
        this(learner, 100);
    }

    public BinaryBaggingLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> learner, int maxIterations) {
        this(learner, maxIterations, new Random());
    }

    public BinaryBaggingLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> learner, int maxIterations, Random random) {
        super(maxIterations);
        this.setLearner(learner);
        this.setRandom(random);
        this.setEnsemble(null);
        this.setDataList(null);
    }

    @Override
    protected boolean initializeAlgorithm() {
        if (this.getData() == null || ((Collection)this.getData()).size() <= 0) {
            return false;
        }
        WeightedBinaryEnsemble localEmsemble = new WeightedBinaryEnsemble(new ArrayList(this.getMaxIterations()));
        this.setEnsemble(localEmsemble);
        this.setDataList(new ArrayList<InputOutputPair<? extends InputType, Boolean>>((Collection)this.getData()));
        return true;
    }

    @Override
    protected boolean step() {
        int count = this.getDataList().size();
        ArrayList<InputOutputPair<? extends InputType, Boolean>> bag = new ArrayList<InputOutputPair<? extends InputType, Boolean>>(count);
        for (int i = 0; i < count; ++i) {
            int index = this.getRandom().nextInt(count);
            InputOutputPair<? extends InputType, Boolean> example = this.dataList.get(index);
            bag.add(example);
        }
        Evaluator<? super InputType, ? extends Boolean> learned = this.learner.learn(bag);
        this.ensemble.add(learned, 1.0);
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
        this.setDataList(null);
    }

    public WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> getResult() {
        return this.getEnsemble();
    }

    @Override
    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> getLearner() {
        return this.learner;
    }

    public void setLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> learner) {
        this.learner = learner;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> getEnsemble() {
        return this.ensemble;
    }

    protected void setEnsemble(WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> ensemble) {
        this.ensemble = ensemble;
    }

    public ArrayList<InputOutputPair<? extends InputType, Boolean>> getDataList() {
        return this.dataList;
    }

    protected void setDataList(ArrayList<InputOutputPair<? extends InputType, Boolean>> dataList) {
        this.dataList = dataList;
    }
}

