/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.initializer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.GaussianCluster;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.AbstractRandomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Now extends AbstractRandomized.", "Got rid of C-style comments from inside methods.", "Cleaned up javadoc a little bit with code annotations.", "Otherwise, looks fine."})
public class NeighborhoodGaussianClusterInitializer
extends AbstractRandomized
implements FixedClusterInitializer<GaussianCluster, Vector> {
    public static final double DEFAULT_RANGE = 1.0;
    public static final double DEFAULT_COVARIANCE = 1.0;
    private double defaultCovariance;
    private double randomRange;

    public NeighborhoodGaussianClusterInitializer() {
        this(new Random());
    }

    public NeighborhoodGaussianClusterInitializer(Random random) {
        this(1.0, 1.0, random);
    }

    public NeighborhoodGaussianClusterInitializer(double defaultCovariance, double randomRange, Random random) {
        super(random);
        this.setDefaultCovariance(defaultCovariance);
        this.setRandomRange(randomRange);
    }

    public double getRandomRange() {
        return this.randomRange;
    }

    public void setRandomRange(double randomRange) {
        this.randomRange = randomRange;
    }

    public double getDefaultCovariance() {
        return this.defaultCovariance;
    }

    public void setDefaultCovariance(double defaultCovariance) {
        this.defaultCovariance = defaultCovariance;
    }

    @Override
    public ArrayList<GaussianCluster> initializeClusters(int numClusters, Collection<? extends Vector> elements) {
        if (numClusters < 0) {
            throw new IllegalArgumentException("The number of clusters cannot be negative.");
        }
        if (elements == null) {
            throw new NullPointerException("The elements cannot be null.");
        }
        if (numClusters == 0 || elements.size() == 0) {
            return new ArrayList<GaussianCluster>();
        }
        ArrayList<? extends Vector> elementsArray = new ArrayList<Vector>(elements);
        ArrayList<GaussianCluster> clusterList = new ArrayList<GaussianCluster>();
        for (int k = 0; k < numClusters; ++k) {
            Vector mean = null;
            double minDiff = 0.0;
            while (minDiff <= 0.0) {
                int index = this.random.nextInt(elements.size());
                Vector data = elementsArray.get(index);
                Vector randomNoise = VectorFactory.getDefault().createUniformRandom(data.getDimensionality(), -this.getRandomRange(), this.getRandomRange(), this.random);
                mean = (Vector)data.plus((Ring)randomNoise);
                minDiff = Double.POSITIVE_INFINITY;
                for (int i = 0; i < k; ++i) {
                    Vector otherMean = clusterList.get(i).getGaussian().getMean();
                    double diff = mean.euclideanDistance(otherMean);
                    if (!(minDiff > diff)) continue;
                    minDiff = diff;
                }
            }
            int M = mean.getDimensionality();
            Matrix covariance = (Matrix)MatrixFactory.getDefault().createIdentity(M, M).scale(this.getDefaultCovariance());
            MultivariateGaussian.PDF gaussian = new MultivariateGaussian.PDF(mean, covariance);
            GaussianCluster cluster = new GaussianCluster(null, gaussian);
            clusterList.add(cluster);
        }
        return clusterList;
    }
}

