/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.KMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Made setRemovalThreshold check to ensure removalThreshold is < 1.0", "Cleaned up javadoc.", "Code generally looks fine."})
public class KMeansClustererWithRemoval<DataType, ClusterType extends Cluster<DataType>>
extends KMeansClusterer<DataType, ClusterType> {
    private double removalThreshold;

    public KMeansClustererWithRemoval() {
    }

    public KMeansClustererWithRemoval(int numRequestedClusters, int maxIterations, FixedClusterInitializer<ClusterType, DataType> initializer, ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, double removalThreshold) {
        super(numRequestedClusters, maxIterations, initializer, divergenceFunction, creator);
        this.setRemovalThreshold(removalThreshold);
    }

    public double getRemovalThreshold() {
        return this.removalThreshold;
    }

    public void setRemovalThreshold(double removalThreshold) {
        if (removalThreshold >= 1.0) {
            throw new IllegalArgumentException("removalThreshold must be < 1.0");
        }
        this.removalThreshold = removalThreshold;
    }

    protected void removeCluster(int clusterIndex) {
        this.getClusters().remove(clusterIndex);
        int[] assigns = this.getAssignments();
        for (int i = 0; i < this.getNumElements(); ++i) {
            if (assigns[i] == clusterIndex) {
                this.setAssignment(i, -1);
                continue;
            }
            if (assigns[i] <= clusterIndex) continue;
            this.setAssignment(i, assigns[i] - 1);
        }
    }

    @Override
    protected boolean step() {
        int clusterCount;
        int i;
        boolean superStepReturn = super.step();
        int removalNumber = (int)Math.floor(this.getRemovalThreshold() * (double)this.getNumElements() / (double)this.getNumClusters());
        int minCount = this.getNumElements();
        int minIndex = -1;
        for (i = 0; i < this.getNumClusters(); ++i) {
            clusterCount = this.getClusterCounts()[i];
            if (minCount <= clusterCount) continue;
            minCount = clusterCount;
            minIndex = i;
        }
        for (i = this.getNumClusters() - 1; i >= 0; --i) {
            clusterCount = this.clusterCounts[i];
            if (clusterCount > removalNumber) continue;
            this.removeCluster(i);
            this.setNumChanged(this.getNumChanged() + clusterCount + 1);
        }
        return superStepReturn;
    }
}

