/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.bayes;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.DiscriminantCategorizer;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicationReferences(references={@PublicationReference(author={"Richard O. Duda", "Peter E. Hart", "David G. Stork"}, title="Pattern Classification: Second Edition", type=PublicationType.Book, year=2001, pages={56, 62}), @PublicationReference(author={"Wikipedia"}, title="Naive Bayes classifier", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Naive_bayes")})
public class DiscreteNaiveBayesCategorizer<InputType, CategoryType>
extends AbstractCloneableSerializable
implements DiscriminantCategorizer<Collection<InputType>, CategoryType, Double> {
    private Map<CategoryType, List<MapBasedDataHistogram<InputType>>> conditionalProbabilities;
    private MapBasedDataHistogram<CategoryType> priorProbabilities;
    private int inputDimensionality;

    public DiscreteNaiveBayesCategorizer() {
        this(0);
    }

    public DiscreteNaiveBayesCategorizer(int inputDimensionality) {
        this.setInputDimensionality(inputDimensionality);
    }

    protected DiscreteNaiveBayesCategorizer(int inputDimensionality, MapBasedDataHistogram<CategoryType> priorProbabilities, Map<CategoryType, List<MapBasedDataHistogram<InputType>>> conditionalProbabilities) {
        this.setInputDimensionality(inputDimensionality);
        this.priorProbabilities = priorProbabilities;
        this.conditionalProbabilities = conditionalProbabilities;
    }

    public DiscreteNaiveBayesCategorizer<InputType, CategoryType> clone() {
        DiscreteNaiveBayesCategorizer clone = (DiscreteNaiveBayesCategorizer)super.clone();
        clone.conditionalProbabilities = new LinkedHashMap<CategoryType, List<MapBasedDataHistogram<InputType>>>();
        for (CategoryType category : this.getCategories()) {
            clone.conditionalProbabilities.put(category, ObjectUtil.cloneSmartElementsAsArrayList((Collection)this.conditionalProbabilities.get(category)));
        }
        clone.priorProbabilities = (MapBasedDataHistogram)ObjectUtil.cloneSafe(this.priorProbabilities);
        return clone;
    }

    @Override
    public Set<CategoryType> getCategories() {
        return this.priorProbabilities.getDomain();
    }

    public double computeEvidenceProbabilty(Collection<InputType> inputs) {
        double prob = 0.0;
        for (CategoryType category : this.getCategories()) {
            prob += this.computeConjuctiveProbability(inputs, category);
        }
        return prob;
    }

    public double computePosterior(Collection<InputType> inputs, CategoryType category) {
        double evidenceProbability = this.computeEvidenceProbabilty(inputs);
        if (evidenceProbability > 0.0) {
            double numerator = this.computeConjuctiveProbability(inputs, category);
            return numerator / evidenceProbability;
        }
        return 0.0;
    }

    public double computeConditionalProbability(Collection<InputType> inputs, CategoryType category) {
        if (inputs.size() != this.getInputDimensionality()) {
            throw new IllegalArgumentException("Input dimensionality doesn't match " + this.getInputDimensionality());
        }
        Iterator<MapBasedDataHistogram<InputType>> conditionalPMFIterator = this.conditionalProbabilities.get(category).iterator();
        double conditionalProbability = 1.0;
        for (InputType input : inputs) {
            MapBasedDataHistogram<InputType> conditionalPMF = conditionalPMFIterator.next();
            if (input != null) {
                conditionalProbability *= conditionalPMF.getFraction(input);
            }
            if (!(conditionalProbability <= 0.0)) continue;
            break;
        }
        return conditionalProbability;
    }

    public void update(Collection<InputType> inputs, CategoryType category) {
        if (this.getInputDimensionality() <= 0) {
            this.setInputDimensionality(inputs.size());
        }
        if (inputs.size() != this.getInputDimensionality()) {
            throw new IllegalArgumentException("Input dimensionality doesn't match " + this.getInputDimensionality());
        }
        if (!this.getCategories().contains(category)) {
            ArrayList conditional = new ArrayList(this.getInputDimensionality());
            for (int i = 0; i < this.getInputDimensionality(); ++i) {
                conditional.add(new MapBasedDataHistogram());
            }
            this.conditionalProbabilities.put(category, conditional);
        }
        this.priorProbabilities.add(category);
        Iterator<MapBasedDataHistogram<InputType>> conditionalPMFIterator = this.conditionalProbabilities.get(category).iterator();
        for (InputType input : inputs) {
            MapBasedDataHistogram<InputType> conditionalPMF = conditionalPMFIterator.next();
            if (input == null) continue;
            conditionalPMF.add(input);
        }
    }

    public double computeConjuctiveProbability(Collection<InputType> inputs, CategoryType category) {
        double categoryPrior = this.getPriorProbability(category);
        if (categoryPrior > 0.0) {
            double conditionalProbability = this.computeConditionalProbability(inputs, category);
            return conditionalProbability * categoryPrior;
        }
        return 0.0;
    }

    public CategoryType evaluate(Collection<InputType> inputs) {
        return (CategoryType)this.evaluateWithDiscriminant(inputs).getValue();
    }

    public DefaultWeightedValueDiscriminant<CategoryType> evaluateWithDiscriminant(Collection<InputType> input) {
        double maxPosterior = -1.0;
        Object maxCategory = null;
        for (CategoryType category : this.getCategories()) {
            double posterior = this.computeConjuctiveProbability(input, category);
            if (!(maxPosterior < posterior)) continue;
            maxPosterior = posterior;
            maxCategory = category;
        }
        return DefaultWeightedValueDiscriminant.create(maxCategory, maxPosterior);
    }

    public double getConditionalProbability(int index, InputType input, CategoryType category) {
        return this.conditionalProbabilities.get(category).get(index).getFraction(input);
    }

    public double getPriorProbability(CategoryType category) {
        return this.priorProbabilities.getFraction(category);
    }

    public int getInputDimensionality() {
        return this.inputDimensionality;
    }

    public void setInputDimensionality(int inputDimensionality) {
        this.conditionalProbabilities = new LinkedHashMap<CategoryType, List<MapBasedDataHistogram<InputType>>>();
        this.priorProbabilities = new MapBasedDataHistogram();
        this.inputDimensionality = inputDimensionality;
    }

    public static class Learner<InputType, CategoryType>
    extends AbstractCloneableSerializable
    implements SupervisedBatchLearner<Collection<InputType>, CategoryType, DiscreteNaiveBayesCategorizer<InputType, CategoryType>> {
        @Override
        public DiscreteNaiveBayesCategorizer<InputType, CategoryType> learn(Collection<? extends InputOutputPair<? extends Collection<InputType>, CategoryType>> data) {
            DiscreteNaiveBayesCategorizer<InputType, CategoryType> nbc = new DiscreteNaiveBayesCategorizer<InputType, CategoryType>();
            for (InputOutputPair<Collection<InputType>, CategoryType> sample : data) {
                nbc.update(sample.getInput(), sample.getOutput());
            }
            return nbc;
        }
    }
}

