/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.feature.DelayFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;
import java.util.Collection;

public class TimeSeriesPredictionLearner<InputType, OutputType, EvaluatorType extends Evaluator<? super InputType, ? extends OutputType>>
extends AbstractCloneableSerializable
implements SupervisedBatchLearner<InputType, OutputType, EvaluatorType> {
    public static final int DEFAULT_PREDICTION_HORIZON = 1;
    private int predictionHorizon;
    private SupervisedBatchLearner<InputType, OutputType, EvaluatorType> supervisedLearner;

    public TimeSeriesPredictionLearner() {
        this(1);
    }

    public TimeSeriesPredictionLearner(int predictionHorizon) {
        this(predictionHorizon, null);
    }

    public TimeSeriesPredictionLearner(int predictionHorizon, SupervisedBatchLearner<InputType, OutputType, EvaluatorType> supervisedLearner) {
        this.setPredictionHorizon(predictionHorizon);
        this.setSupervisedLearner(supervisedLearner);
    }

    public int getPredictionHorizon() {
        return this.predictionHorizon;
    }

    public void setPredictionHorizon(int predictionHorizon) {
        this.predictionHorizon = predictionHorizon;
    }

    public SupervisedBatchLearner<InputType, OutputType, EvaluatorType> getSupervisedLearner() {
        return this.supervisedLearner;
    }

    public void setSupervisedLearner(SupervisedBatchLearner<InputType, OutputType, EvaluatorType> supervisedLearner) {
        this.supervisedLearner = supervisedLearner;
    }

    @Override
    public EvaluatorType learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
        ArrayList<InputOutputPair<InputType, OutputType>> predictionData = TimeSeriesPredictionLearner.createPredictionDataset(this.getPredictionHorizon(), data);
        return (EvaluatorType)((Evaluator)this.getSupervisedLearner().learn(predictionData));
    }

    public static <InputType, OutputType> ArrayList<InputOutputPair<InputType, OutputType>> createPredictionDataset(int predictionHorizon, Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
        int capacity = data.size() - predictionHorizon;
        if (capacity < 0) {
            capacity = 0;
        }
        ArrayList<InputOutputPair<InputType, OutputType>> result = new ArrayList<InputOutputPair<InputType, OutputType>>(capacity);
        DelayFunction<InputType> delay = new DelayFunction<InputType>(predictionHorizon);
        int index = -predictionHorizon;
        for (InputOutputPair<InputType, OutputType> value : data) {
            Object laggedInput = delay.evaluate(value.getInput());
            if (index >= 0) {
                result.add(new DefaultInputOutputPair(laggedInput, value.getOutput()));
            }
            ++index;
        }
        return result;
    }
}

