/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.processes;

import java.io.File;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.openimaj.util.array.ArrayUtils;
import org.openimaj.util.processes.ProcessException;

public class JavaProcess {
    public static void runProcess(Class<?> clz, String[] args) throws ProcessException {
        ProcessOptions opts = new ProcessOptions(clz);
        opts.setArgs(args);
        JavaProcess.runProcess(opts);
    }

    public static void runProcess(Class<?> clz, String argString) throws ProcessException {
        ProcessOptions opts = new ProcessOptions(clz);
        opts.setArgs(argString);
        JavaProcess.runProcess(opts);
    }

    public static void runProcess(Class<?> clz, String[] jvmArgs, String[] args) throws ProcessException {
        ProcessOptions opts = new ProcessOptions(clz);
        opts.setArgs(args);
        opts.setJvmArgs(jvmArgs);
        JavaProcess.runProcess(opts);
    }

    public static void runProcess(Class<?> clz, String jvmArgs, String argString) throws ProcessException {
        ProcessOptions opts = new ProcessOptions(clz);
        opts.setArgs(argString);
        opts.setJvmArgs(jvmArgs);
        JavaProcess.runProcess(opts);
    }

    public static void runProcess(ProcessOptions op) throws ProcessException {
        Project project = new Project();
        project.setBaseDir(op.workingDir);
        project.init();
        project.fireBuildStarted();
        BuildException caught = null;
        try {
            Java java = new Java();
            java.setNewenvironment(true);
            java.setTaskName("runjava");
            java.setProject(project);
            java.setFork(true);
            java.setFailonerror(true);
            op.setup(java);
            java.init();
            java.execute();
        }
        catch (BuildException e) {
            caught = e;
            throw new ProcessException(caught);
        }
        finally {
            project.log("finished");
            project.fireBuildFinished((Throwable)caught);
        }
    }

    private static class SimpleListener
    implements BuildListener {
        Java proc;
        boolean outputOut;
        boolean outputErr;

        SimpleListener(Java proc, boolean outputOut, boolean outputErr) {
            this.proc = proc;
            this.outputOut = outputOut;
            this.outputErr = outputErr;
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (this.proc != event.getSource()) {
                return;
            }
            if (this.outputOut && event.getPriority() == 2) {
                System.out.println(event.getMessage());
            } else if (this.outputErr && event.getPriority() == 0) {
                System.err.println(event.getMessage());
            }
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }
    }

    public static class ProcessOptions {
        File workingDir = new File(System.getProperty("user.dir", new File(".").getAbsolutePath()));
        String classPath;
        String mainClass;
        String jvmArgs;
        File jarFile;
        String args;
        boolean cloneVM;
        boolean outputErr = true;
        boolean outputOut = true;

        public ProcessOptions(Class<?> clz) {
            this.mainClass = clz.getName();
            this.cloneVM = true;
        }

        public ProcessOptions(File jarFile) {
            this.jarFile = jarFile;
            this.cloneVM = false;
        }

        public ProcessOptions(String classPath, String mainClass) {
            this.classPath = classPath;
            this.mainClass = mainClass;
            this.cloneVM = false;
        }

        public void setWorkingDirectory(File workingDir) {
            if (workingDir == null) {
                workingDir = new File(System.getProperty("user.dir", new File(".").getAbsolutePath()));
            }
            this.workingDir = workingDir;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public void setArgs(String[] args) {
            this.args = ArrayUtils.toString(args, " ");
        }

        public void setJvmArgs(String jvmArgs) {
            this.jvmArgs = jvmArgs;
        }

        public void setJvmArgs(String[] jvmArgs) {
            this.jvmArgs = ArrayUtils.toString(jvmArgs, " ");
        }

        protected void setup(Java java) {
            if (this.jarFile != null) {
                java.setJar(this.jarFile);
            } else {
                if (this.classPath == null) {
                    java.setClasspath(Path.systemClasspath);
                } else {
                    java.setClasspath(new Path(java.getProject(), this.classPath));
                }
                java.setClassname(this.mainClass);
            }
            if (this.jvmArgs != null) {
                Commandline.Argument jvmArg = java.createJvmarg();
                jvmArg.setLine(this.jvmArgs);
            }
            if (this.args != null) {
                Commandline.Argument taskArgs = java.createArg();
                taskArgs.setLine(this.args);
            }
            java.getProject().addBuildListener((BuildListener)new SimpleListener(java, this.outputOut, this.outputErr));
            java.setCloneVm(this.cloneVM);
        }

        public void outputErr(boolean outputErr) {
            this.outputErr = outputErr;
        }

        public void outputOut(boolean outputOut) {
            this.outputOut = outputOut;
        }
    }
}

