/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.array;

import gnu.trove.iterator.TIntShortIterator;
import gnu.trove.map.TIntShortMap;
import gnu.trove.map.hash.TIntShortHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openimaj.util.array.SparseShortArray;

public class SparseHashedShortArray
extends SparseShortArray {
    TIntShortHashMap data;

    public SparseHashedShortArray(short[] values) {
        this(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            this.set(i, values[i]);
        }
    }

    public SparseHashedShortArray(int length) {
        this(length, 10);
    }

    public SparseHashedShortArray(int length, int capacity) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be > 0");
        }
        this.length = length;
        this.data = new TIntShortHashMap(capacity);
    }

    public SparseHashedShortArray(int length, float density) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        if (density <= 0.0f || density > 1.0f) {
            throw new IllegalArgumentException("density must be > 0 and < 1");
        }
        this.length = length;
        int capacity = (int)(density * (float)length);
        this.data = new TIntShortHashMap(capacity);
    }

    @Override
    public short increment(int key, short value) {
        return this.data.adjustOrPutValue(key, value, value);
    }

    @Override
    public int[] indices() {
        return this.data.keys();
    }

    @Override
    public short[] values() {
        return this.data.values();
    }

    @Override
    public Iterable<SparseShortArray.Entry> entries() {
        return new Iterable<SparseShortArray.Entry>(){

            @Override
            public Iterator<SparseShortArray.Entry> iterator() {
                return new Iterator<SparseShortArray.Entry>(){
                    private SparseShortArray.Entry entry = new SparseShortArray.Entry();
                    private TIntShortIterator iterator;
                    {
                        this.iterator = SparseHashedShortArray.this.data.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public SparseShortArray.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.iterator.advance();
                        this.entry.index = this.iterator.key();
                        this.entry.value = this.iterator.value();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SparseHashedShortArray)) {
            return false;
        }
        return this.length == ((SparseHashedShortArray)obj).length && this.data.equals((Object)((SparseHashedShortArray)obj).data);
    }

    @Override
    public short get(int key) {
        if (key < 0 || key >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        return this.data.get(key);
    }

    public int hashCode() {
        return this.length ^ this.data.hashCode();
    }

    @Override
    public boolean isUsed(int key) {
        return this.data.contains(key);
    }

    @Override
    public short set(int key, short value) {
        return this.data.put(key, value);
    }

    @Override
    public int used() {
        return this.data.size();
    }

    @Override
    public void compact() {
        this.data.compact();
    }

    @Override
    public SparseShortArray copy() {
        SparseHashedShortArray copy = new SparseHashedShortArray(this.length);
        copy.data = new TIntShortHashMap((TIntShortMap)this.data);
        return copy;
    }

    @Override
    public SparseShortArray reverse() {
        TIntShortHashMap tmp = new TIntShortHashMap(this.data.size());
        for (SparseShortArray.Entry e : this.entries()) {
            tmp.put(this.length - e.index, e.value);
        }
        this.data = tmp;
        return this;
    }
}

