/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openimaj.data.RandomData;
import org.openimaj.util.CollectionSampler;

public class UniformSampler<T>
implements CollectionSampler<T> {
    private List<T> data;

    @Override
    public void setCollection(Collection<? extends T> collection) {
        this.data = new ArrayList<T>(collection);
    }

    @Override
    public List<T> sample(int nItems) {
        int[] rints = RandomData.getUniqueRandomInts(nItems, 0, this.data.size());
        ArrayList<T> out = new ArrayList<T>(nItems);
        for (int i : rints) {
            out.add(this.data.get(i));
        }
        return out;
    }
}

