/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.openimaj.io.ReadableBinary;
import org.openimaj.io.WriteableBinary;

public abstract class ReadWriteableListBinary<V>
implements ReadableBinary,
WriteableBinary {
    public List<V> value;

    public ReadWriteableListBinary(List<V> list) {
        this.value = list;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.value.size());
        for (V v : this.value) {
            this.writeValue(v, out);
        }
    }

    protected abstract void writeValue(V var1, DataOutput var2) throws IOException;

    @Override
    public void readBinary(DataInput in) throws IOException {
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            this.value.add(this.readValue(in));
        }
    }

    protected abstract V readValue(DataInput var1) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return this.value.getClass().getName().getBytes();
    }
}

