/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.demangling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridj.CLong;
import org.bridj.NativeLibrary;
import org.bridj.demangling.Demangler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCC4Demangler
extends Demangler {
    private Map<String, List<Demangler.IdentLike>> prefixShortcuts = new HashMap<String, List<Demangler.IdentLike>>(){
        {
            this.put("t", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0])));
            this.put("a", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("allocator", new Demangler.TemplateArg[0])));
            this.put("b", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("basic_string", new Demangler.TemplateArg[0])));
            Demangler.TypeRef chartype = Demangler.classType(Byte.TYPE, new Class[0]);
            Demangler.ClassRef charTraitsOfChar = this.enclosed("std", new Demangler.ClassRef(new Demangler.Ident("char_traits", chartype)));
            Demangler.ClassRef allocatorOfChar = this.enclosed("std", new Demangler.ClassRef(new Demangler.Ident("allocator", chartype)));
            this.put("d", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("basic_iostream", chartype, charTraitsOfChar)));
            this.put("i", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("basic_istream", chartype, charTraitsOfChar)));
            this.put("o", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("basic_ostream", chartype, charTraitsOfChar)));
            this.put("s", Arrays.asList(new Demangler.Ident("std", new Demangler.TemplateArg[0]), new Demangler.Ident("basic_string", Demangler.classType(Byte.TYPE, new Class[0]), charTraitsOfChar, allocatorOfChar)));
        }

        private Demangler.ClassRef enclosed(String ns, Demangler.ClassRef classRef) {
            classRef.setEnclosingType(new Demangler.NamespaceRef(new Demangler.Ident(ns, new Demangler.TemplateArg[0])));
            return classRef;
        }
    };
    private Set<String> shouldContinueAfterPrefix = new HashSet<String>(Arrays.asList("t"));
    private Map<String, Demangler.TypeRef> typeShortcuts = new HashMap<String, Demangler.TypeRef>();
    int nextShortcutId = -1;

    public GCC4Demangler(NativeLibrary library, String symbol) {
        super(library, symbol);
    }

    private <T> T ensureOfType(Object o, Class<T> type) throws Demangler.DemanglingException {
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        throw new Demangler.DemanglingException(this, "Internal error in demangler: trying to cast to " + type.getCanonicalName() + " the object '" + o.toString() + "'");
    }

    private String nextShortcutId() {
        int n;
        return (n = this.nextShortcutId++) == -1 ? "_" : Integer.toString(n, 36).toUpperCase() + "_";
    }

    private Demangler.TypeRef parsePointerType(boolean memorizePointed) throws Demangler.DemanglingException {
        String subId = memorizePointed ? this.nextShortcutId() : null;
        Demangler.TypeRef pointed = this.parseType();
        if (memorizePointed) {
            this.typeShortcuts.put(subId, pointed);
        }
        Demangler.TypeRef res = GCC4Demangler.pointerType(pointed);
        String id = this.nextShortcutId();
        this.typeShortcuts.put(id, res);
        return res;
    }

    public Demangler.TemplateArg parseTemplateArg() throws Demangler.DemanglingException {
        if (this.consumeCharIf('L')) {
            char c;
            Demangler.TypeRef tr = this.parseType();
            StringBuffer b = new StringBuffer();
            while (Character.isDigit(c = this.peekChar())) {
                this.consumeChar();
                b.append(c);
            }
            this.expectChars('E');
            return new Demangler.Constant(Integer.parseInt(b.toString()));
        }
        return this.parseType();
    }

    public Demangler.TypeRef parseType() throws Demangler.DemanglingException {
        if (Character.isDigit(this.peekChar())) {
            Demangler.Ident name = this.ensureOfType(this.parseNonCompoundIdent(), Demangler.Ident.class);
            String id = this.nextShortcutId();
            Demangler.TypeRef res = GCC4Demangler.simpleType(name);
            this.typeShortcuts.put(id, res);
            return res;
        }
        char c = this.consumeChar();
        switch (c) {
            case 'S': {
                char cc = this.peekChar();
                int delta = 0;
                if (Character.isDigit(cc) || Character.isUpperCase(cc) || cc == '_') {
                    String id = "";
                    while ((c = this.peekChar()) != '_' && c != '\u0000') {
                        id = id + this.consumeChar();
                        ++delta;
                    }
                    if (this.peekChar() == '\u0000') {
                        throw new Demangler.DemanglingException(this, "Encountered a unexpected end in gcc mangler shortcut '" + id + "' " + this.prefixShortcuts.keySet());
                    }
                    id = id + this.consumeChar();
                    ++delta;
                    if (this.typeShortcuts.containsKey(id)) {
                        if (this.peekChar() != 'I') {
                            return this.typeShortcuts.get(id);
                        }
                        ArrayList<Demangler.IdentLike> nsPath = new ArrayList<Demangler.IdentLike>((Collection)this.prefixShortcuts.get(id));
                        String templatedId = this.parsePossibleTemplateArguments(nsPath);
                        if (templatedId != null) {
                            return this.typeShortcuts.get(templatedId);
                        }
                    }
                    this.position -= delta;
                }
            }
            case 'N': {
                --this.position;
                ArrayList<Demangler.IdentLike> ns = new ArrayList<Demangler.IdentLike>();
                String newShortcutId = this.parseSimpleOrComplexIdentInto(ns, false);
                Demangler.ClassRef res = new Demangler.ClassRef(this.ensureOfType(ns.remove(ns.size() - 1), Demangler.Ident.class));
                if (!ns.isEmpty()) {
                    res.setEnclosingType(new Demangler.NamespaceRef(ns.toArray()));
                }
                if (newShortcutId != null) {
                    this.typeShortcuts.put(newShortcutId, res);
                }
                return res;
            }
            case 'P': {
                char nextChar = this.peekChar();
                return this.parsePointerType(nextChar == 'K' || nextChar == 'N');
            }
            case 'F': {
                Demangler.MemberRef mr = new Demangler.MemberRef();
                mr.setValueType(this.parseType());
                ArrayList<Demangler.TypeRef> argTypes = new ArrayList<Demangler.TypeRef>();
                while (this.peekChar() != 'E') {
                    argTypes.add(this.parseType());
                }
                mr.paramTypes = argTypes.toArray(new Demangler.TypeRef[argTypes.size()]);
                this.expectChars('E');
                return new Demangler.FunctionTypeRef(mr);
            }
            case 'K': {
                return this.parseType();
            }
            case 'v': {
                return GCC4Demangler.classType(Void.TYPE, new Class[0]);
            }
            case 'a': 
            case 'c': 
            case 'h': {
                return GCC4Demangler.classType(Byte.TYPE, new Class[0]);
            }
            case 'b': {
                return GCC4Demangler.classType(Boolean.TYPE, new Class[0]);
            }
            case 'l': 
            case 'm': {
                return GCC4Demangler.classType(CLong.class, new Class[0]);
            }
            case 'x': 
            case 'y': {
                return GCC4Demangler.classType(Long.TYPE, new Class[0]);
            }
            case 'i': 
            case 'j': {
                return GCC4Demangler.classType(Integer.TYPE, new Class[0]);
            }
            case 's': 
            case 't': {
                return GCC4Demangler.classType(Short.TYPE, new Class[0]);
            }
            case 'f': {
                return GCC4Demangler.classType(Float.TYPE, new Class[0]);
            }
            case 'd': {
                return GCC4Demangler.classType(Double.TYPE, new Class[0]);
            }
            case 'z': {
                return GCC4Demangler.classType(Object[].class, new Class[0]);
            }
        }
        throw this.error("Unexpected type char '" + c + "'", -1);
    }

    String parseName() throws Demangler.DemanglingException {
        int len;
        char c;
        StringBuilder b = new StringBuilder();
        while (Character.isDigit(c = this.peekChar())) {
            this.consumeChar();
            b.append(c);
        }
        try {
            len = Integer.parseInt(b.toString());
        }
        catch (NumberFormatException ex) {
            throw this.error("Expected a number", 0);
        }
        b.setLength(0);
        for (int i = 0; i < len; ++i) {
            b.append(this.consumeChar());
        }
        return b.toString();
    }

    private String parseSimpleOrComplexIdentInto(List<Demangler.IdentLike> res, boolean isParsingNonShortcutableElement) throws Demangler.DemanglingException {
        String newlyAddedShortcutForThisType = null;
        boolean shouldContinue = false;
        boolean expectEInTheEnd = false;
        if (this.consumeCharIf('N')) {
            if (this.consumeCharIf('S')) {
                this.parseShortcutInto(res);
            }
            shouldContinue = true;
            expectEInTheEnd = true;
        } else if (this.consumeCharIf('S')) {
            shouldContinue = this.parseShortcutInto(res);
        } else {
            res.add(this.parseNonCompoundIdent());
        }
        if (shouldContinue) {
            int initialNextShortcutId = this.nextShortcutId;
            do {
                String id;
                newlyAddedShortcutForThisType = id = this.nextShortcutId();
                Demangler.IdentLike part = this.parseNonCompoundIdent();
                res.add(part);
                this.prefixShortcuts.put(id, new ArrayList<Demangler.IdentLike>(res));
                this.parsePossibleTemplateArguments(res);
            } while (Character.isDigit(this.peekChar()) || this.peekChar() == 'C' || this.peekChar() == 'D');
            if (isParsingNonShortcutableElement) {
                this.nextShortcutId = initialNextShortcutId;
            }
        }
        this.parsePossibleTemplateArguments(res);
        if (expectEInTheEnd) {
            this.expectAnyChar('E');
        }
        return newlyAddedShortcutForThisType;
    }

    private String parsePossibleTemplateArguments(List<Demangler.IdentLike> res) throws Demangler.DemanglingException {
        if (this.consumeCharIf('I')) {
            ArrayList<Demangler.TemplateArg> args = new ArrayList<Demangler.TemplateArg>();
            while (!this.consumeCharIf('E')) {
                args.add(this.parseTemplateArg());
            }
            String id = this.nextShortcutId();
            Demangler.Ident templatedIdent = new Demangler.Ident(this.ensureOfType(res.remove(res.size() - 1), Demangler.Ident.class).toString(), args.toArray(new Demangler.TemplateArg[args.size()]));
            res.add(templatedIdent);
            this.prefixShortcuts.put(id, new ArrayList<Demangler.IdentLike>(res));
            ArrayList<Demangler.IdentLike> ns = new ArrayList<Demangler.IdentLike>(res);
            Demangler.ClassRef clss = new Demangler.ClassRef(this.ensureOfType(ns.remove(ns.size() - 1), Demangler.Ident.class));
            if (!ns.isEmpty()) {
                clss.setEnclosingType(new Demangler.NamespaceRef(ns.toArray()));
            }
            this.typeShortcuts.put(id, clss);
            return id;
        }
        return null;
    }

    private boolean parseShortcutInto(List<Demangler.IdentLike> res) throws Demangler.DemanglingException {
        char c = this.peekChar();
        if (c == '_') {
            List<Demangler.IdentLike> toAdd = this.prefixShortcuts.get(Character.toString(this.consumeChar()));
            if (toAdd == null) {
                throw new Demangler.DemanglingException(this, "Encountered a yet undefined gcc mangler shortcut S_ (first one), i.e. '_' " + this.prefixShortcuts.keySet());
            }
            res.addAll(toAdd);
            return false;
        }
        if (Character.isDigit(c) || Character.isUpperCase(c)) {
            String id = "";
            while ((c = this.peekChar()) != '_' && c != '\u0000') {
                id = id + this.consumeChar();
            }
            if (this.peekChar() == '\u0000') {
                throw new Demangler.DemanglingException(this, "Encountered a unexpected end in gcc mangler shortcut '" + id + "' " + this.prefixShortcuts.keySet());
            }
            List<Demangler.IdentLike> toAdd = this.prefixShortcuts.get(id = id + this.consumeChar());
            if (toAdd == null) {
                throw new Demangler.DemanglingException(this, "Encountered a unexpected gcc mangler shortcut '" + id + "' " + this.prefixShortcuts.keySet());
            }
            res.addAll(toAdd);
            return false;
        }
        if (Character.isLowerCase(c)) {
            String id = Character.toString(this.consumeChar());
            List<Demangler.IdentLike> toAdd = this.prefixShortcuts.get(id);
            if (toAdd == null) {
                throw new Demangler.DemanglingException(this, "Encountered a unexpected gcc mangler built-in shortcut '" + id + "' " + this.prefixShortcuts.keySet());
            }
            res.addAll(toAdd);
            return this.shouldContinueAfterPrefix.contains(id);
        }
        throw new Demangler.DemanglingException(this, "Encountered a unexpected gcc unknown shortcut '" + c + "' " + this.prefixShortcuts.keySet());
    }

    Demangler.IdentLike parseNonCompoundIdent() throws Demangler.DemanglingException {
        if (this.consumeCharIf('C')) {
            if (this.consumeCharIf('1')) {
                return Demangler.SpecialName.Constructor;
            }
            if (this.consumeCharIf('2')) {
                return Demangler.SpecialName.SpecialConstructor;
            }
            throw this.error("Unknown constructor type 'C" + this.peekChar() + "'");
        }
        if (this.consumeCharIf('D')) {
            if (this.consumeCharIf('0')) {
                return Demangler.SpecialName.DeletingDestructor;
            }
            if (this.consumeCharIf('1')) {
                return Demangler.SpecialName.Destructor;
            }
            if (this.consumeCharIf('2')) {
                return Demangler.SpecialName.SelfishDestructor;
            }
            throw this.error("Unknown destructor type 'D" + this.peekChar() + "'");
        }
        String n = this.parseName();
        return new Demangler.Ident(n, new Demangler.TemplateArg[0]);
    }

    @Override
    public Demangler.MemberRef parseSymbol() throws Demangler.DemanglingException {
        Demangler.MemberRef mr = new Demangler.MemberRef();
        if (!this.consumeCharIf('_')) {
            mr.setMemberName(new Demangler.Ident(this.str, new Demangler.TemplateArg[0]));
            return mr;
        }
        this.consumeCharIf('_');
        if (!this.consumeCharIf('Z')) {
            return null;
        }
        if (this.consumeCharIf('T')) {
            if (this.consumeCharIf('V')) {
                mr.setEnclosingType(this.ensureOfType(this.parseType(), Demangler.ClassRef.class));
                mr.setMemberName(Demangler.SpecialName.VFTable);
                return mr;
            }
            return null;
        }
        if (this.consumeCharsIf('d', 'l', 'P', 'v')) {
            mr.setMemberName(Demangler.SpecialName.Delete);
            return mr;
        }
        if (this.consumeCharsIf('d', 'a', 'P', 'v')) {
            mr.setMemberName(Demangler.SpecialName.DeleteArray);
            return mr;
        }
        if (this.consumeCharsIf('n', 'w', 'm')) {
            mr.setMemberName(Demangler.SpecialName.New);
            return mr;
        }
        if (this.consumeCharsIf('n', 'a', 'm')) {
            mr.setMemberName(Demangler.SpecialName.NewArray);
            return mr;
        }
        ArrayList<Demangler.IdentLike> ns = new ArrayList<Demangler.IdentLike>();
        this.parseSimpleOrComplexIdentInto(ns, true);
        mr.setMemberName((Demangler.IdentLike)ns.remove(ns.size() - 1));
        if (!ns.isEmpty()) {
            Demangler.ClassRef parent = new Demangler.ClassRef(this.ensureOfType(ns.remove(ns.size() - 1), Demangler.Ident.class));
            if (mr.getMemberName() == Demangler.SpecialName.Constructor || mr.getMemberName() == Demangler.SpecialName.SpecialConstructor) {
                this.typeShortcuts.put(this.nextShortcutId(), parent);
            }
            if (!ns.isEmpty()) {
                parent.setEnclosingType(new Demangler.NamespaceRef(ns.toArray()));
            }
            mr.setEnclosingType(parent);
        }
        if (this.consumeCharIf('v')) {
            if (this.position < this.length) {
                this.error("Expected end of symbol", 0);
            }
            mr.paramTypes = new Demangler.TypeRef[0];
        } else {
            ArrayList<Demangler.TypeRef> paramTypes = new ArrayList<Demangler.TypeRef>();
            while (this.position < this.length) {
                paramTypes.add(this.parseType());
            }
            mr.paramTypes = paramTypes.toArray(new Demangler.TypeRef[paramTypes.size()]);
        }
        return mr;
    }
}

