/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.sparse;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.factory.CRSFactory;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.matrix.source.MatrixSource;
import org.la4j.matrix.sparse.AbstractCompressedMatrix;
import org.la4j.matrix.sparse.SparseMatrix;
import org.la4j.vector.Vector;
import org.la4j.vector.sparse.CompressedVector;

public class CRSMatrix
extends AbstractCompressedMatrix
implements SparseMatrix {
    private static final long serialVersionUID = 4071505L;
    private static final int MINIMUM_SIZE = 32;
    private double[] values;
    private int[] columnIndices;
    private int[] rowPointers;

    public CRSMatrix() {
        this(0, 0);
    }

    public CRSMatrix(int rows, int columns) {
        this(rows, columns, 0);
    }

    public CRSMatrix(Matrix matrix) {
        this(Matrices.asUnsafeSource(matrix));
    }

    public CRSMatrix(double[][] array) {
        this(Matrices.asArray2DSource(array));
    }

    public CRSMatrix(MatrixSource source) {
        this(source.rows(), source.columns(), 0);
        for (int i = 0; i < this.rows; ++i) {
            this.rowPointers[i] = this.cardinality;
            for (int j = 0; j < this.columns; ++j) {
                double value = source.get(i, j);
                if (!(Math.abs(value) > Matrices.EPS)) continue;
                if (this.values.length < this.cardinality + 1) {
                    this.growup();
                }
                this.values[this.cardinality] = value;
                this.columnIndices[this.cardinality] = j;
                ++this.cardinality;
            }
        }
        this.rowPointers[this.rows] = this.cardinality;
    }

    public CRSMatrix(int rows, int columns, int cardinality) {
        super(Matrices.CRS_FACTORY, rows, columns);
        int alignedSize = this.align(rows, columns, cardinality);
        this.cardinality = 0;
        this.values = new double[alignedSize];
        this.columnIndices = new int[alignedSize];
        this.rowPointers = new int[rows + 1];
    }

    public CRSMatrix(int rows, int columns, int cardinality, double[] values, int[] columnIndices, int[] rowPointers) {
        super(new CRSFactory(), rows, columns);
        this.cardinality = cardinality;
        this.values = values;
        this.columnIndices = columnIndices;
        this.rowPointers = rowPointers;
    }

    @Override
    public double get(int i, int j) {
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            return this.values[k];
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double value) {
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            if (Math.abs(value) < Matrices.EPS) {
                this.remove(k, i);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, value);
        }
    }

    @Override
    public Matrix transpose(Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Matrix result = factory.createMatrix(this.columns, this.rows);
        int k = 0;
        int i = 0;
        while (k < this.cardinality) {
            int j = this.rowPointers[i];
            while (j < this.rowPointers[i + 1]) {
                result.set(this.columnIndices[j], i, this.values[j]);
                ++j;
                ++k;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Vector getRow(int i) {
        int rowCardinality = this.rowPointers[i + 1] - this.rowPointers[i];
        double[] rowValues = new double[rowCardinality];
        int[] rowIndices = new int[rowCardinality];
        System.arraycopy(this.values, this.rowPointers[i], rowValues, 0, rowCardinality);
        System.arraycopy(this.columnIndices, this.rowPointers[i], rowIndices, 0, rowCardinality);
        return new CompressedVector(this.columns, rowCardinality, rowValues, rowIndices);
    }

    @Override
    public Vector getRow(int i, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.columns);
        for (int ii = this.rowPointers[i]; ii < this.rowPointers[i + 1]; ++ii) {
            result.set(this.columnIndices[ii], this.values[ii]);
        }
        return result;
    }

    @Override
    public Vector getColumn(int j, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.rows);
        int i = 0;
        while (this.rowPointers[i] < this.cardinality) {
            int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
            if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
                result.set(i, this.values[k]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public Matrix copy() {
        double[] $values = new double[this.align(this.rows, this.columns, this.cardinality)];
        int[] $columnIndices = new int[this.align(this.rows, this.columns, this.cardinality)];
        int[] $rowPointers = new int[this.rows + 1];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
        System.arraycopy(this.rowPointers, 0, $rowPointers, 0, this.rows + 1);
        return new CRSMatrix(this.rows, this.columns, this.cardinality, $values, $columnIndices, $rowPointers);
    }

    @Override
    public Matrix resize(int rows, int columns) {
        this.ensureDimensionsAreNotNegative(rows, columns);
        if (this.rows == rows && this.columns == columns) {
            return this.copy();
        }
        if (this.rows >= rows && this.columns >= columns) {
            double[] $values = new double[this.align(rows, columns, this.cardinality)];
            int[] $columnIndices = new int[this.align(rows, columns, this.cardinality)];
            int[] $rowPointers = new int[rows + 1];
            int $cardinality = 0;
            int k = 0;
            for (int i = 0; k < this.cardinality && i < rows; ++i) {
                $rowPointers[i] = $cardinality;
                int j = this.rowPointers[i];
                while (j < this.rowPointers[i + 1] && this.columnIndices[j] < columns) {
                    $values[$cardinality] = this.values[j];
                    $columnIndices[$cardinality] = this.columnIndices[j];
                    ++$cardinality;
                    ++j;
                    ++k;
                }
            }
            $rowPointers[rows] = $cardinality;
            return new CRSMatrix(rows, columns, $cardinality, $values, $columnIndices, $rowPointers);
        }
        if (this.rows < rows) {
            double[] $values = new double[this.align(rows, columns, this.cardinality)];
            int[] $columnIndices = new int[this.align(rows, columns, this.cardinality)];
            int[] $rowPointers = new int[rows + 1];
            System.arraycopy(this.values, 0, $values, 0, this.cardinality);
            System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
            System.arraycopy(this.rowPointers, 0, $rowPointers, 0, this.rows + 1);
            for (int i = this.rows; i < rows + 1; ++i) {
                $rowPointers[i] = this.cardinality;
            }
            return new CRSMatrix(rows, columns, this.cardinality, $values, $columnIndices, $rowPointers);
        }
        double[] $values = new double[this.align(rows, columns, this.cardinality)];
        int[] $columnIndices = new int[this.align(rows, columns, this.cardinality)];
        int[] $rowPointers = new int[rows + 1];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
        System.arraycopy(this.rowPointers, 0, $rowPointers, 0, this.rows + 1);
        return new CRSMatrix(rows, columns, this.cardinality, $values, $columnIndices, $rowPointers);
    }

    @Override
    public void each(MatrixProcedure procedure) {
        int k = 0;
        int i = 0;
        while (k < this.cardinality) {
            int j = this.rowPointers[i];
            while (j < this.rowPointers[i + 1]) {
                procedure.apply(i, this.columnIndices[j], this.values[j]);
                ++j;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public void update(int i, int j, MatrixFunction function) {
        int k = this.searchForColumnIndex(j, this.rowPointers[i], this.rowPointers[i + 1]);
        if (k < this.rowPointers[i + 1] && this.columnIndices[k] == j) {
            double value = function.evaluate(i, j, this.values[k]);
            if (Math.abs(value) < Matrices.EPS) {
                this.remove(k, i);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, function.evaluate(i, j, 0.0));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.columns);
        out.writeInt(this.cardinality);
        int k = 0;
        int i = 0;
        while (k < this.cardinality) {
            int j = this.rowPointers[i];
            while (j < this.rowPointers[i + 1]) {
                out.writeInt(i);
                out.writeInt(this.columnIndices[j]);
                out.writeDouble(this.values[j]);
                ++j;
                ++k;
            }
            ++i;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.cardinality = in.readInt();
        int alignedSize = this.align(this.rows, this.columns, this.cardinality);
        this.values = new double[alignedSize];
        this.columnIndices = new int[alignedSize];
        this.rowPointers = new int[this.rows + 1];
        for (int k = 0; k < this.cardinality; ++k) {
            int i = in.readInt();
            this.columnIndices[k] = in.readInt();
            this.values[k] = in.readDouble();
            this.rowPointers[i + 1] = k + 1;
        }
    }

    private int searchForColumnIndex(int j, int left, int right) {
        if (left == right) {
            return left;
        }
        if (right - left < 8) {
            int jj;
            for (jj = left; jj < right && this.columnIndices[jj] < j; ++jj) {
            }
            return jj;
        }
        int p = (left + right) / 2;
        if (this.columnIndices[p] > j) {
            return this.searchForColumnIndex(j, left, p);
        }
        if (this.columnIndices[p] < j) {
            return this.searchForColumnIndex(j, p + 1, right);
        }
        return p;
    }

    private void insert(int k, int i, int j, double value) {
        if (Math.abs(value) < Matrices.EPS) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growup();
        }
        System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
        System.arraycopy(this.columnIndices, k, this.columnIndices, k + 1, this.cardinality - k);
        this.values[k] = value;
        this.columnIndices[k] = j;
        int ii = i + 1;
        while (ii < this.rows + 1) {
            int n = ii++;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        ++this.cardinality;
    }

    private void remove(int k, int i) {
        --this.cardinality;
        System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
        System.arraycopy(this.columnIndices, k + 1, this.columnIndices, k, this.cardinality - k);
        int ii = i + 1;
        while (ii < this.rows + 1) {
            int n = ii++;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
    }

    private void growup() {
        if (this.values.length == this.rows * this.columns) {
            throw new IllegalStateException("This matrix can't grow up.");
        }
        int capacity = Math.min(this.rows * this.columns, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $columnIndices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.columnIndices, 0, $columnIndices, 0, this.cardinality);
        this.values = $values;
        this.columnIndices = $columnIndices;
    }

    private int align(int rows, int columns, int cardinality) {
        return Math.min(rows * columns, (cardinality / 32 + 1) * 32);
    }
}

