/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.source;

import java.util.Arrays;
import java.util.Random;
import org.la4j.matrix.source.MatrixSource;

public class RandomSymmetricMatrixSource
implements MatrixSource {
    private int size;
    private Random random;
    private double[] values;

    public RandomSymmetricMatrixSource(int size) {
        this.size = size;
        this.random = new Random();
        this.values = new double[(size * size - size) / 2];
        Arrays.fill(this.values, Double.NaN);
    }

    @Override
    public double get(int i, int j) {
        if (i == j) {
            return this.random.nextDouble();
        }
        int offset = -1;
        offset = i < j ? j - (i + 1) + (int)((double)(this.size - 1 + (this.size - i)) / 2.0 * (double)i) : i - (j + 1) + (int)((double)(this.size - 1 + (this.size - j)) / 2.0 * (double)j);
        if (Double.isNaN(this.values[offset])) {
            this.values[offset] = this.random.nextDouble();
        }
        return this.values[offset];
    }

    @Override
    public int columns() {
        return this.size;
    }

    @Override
    public int rows() {
        return this.size;
    }
}

