/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.factory.Factory;
import org.la4j.linear.LinearSystem;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class SeidelSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;
    private static final int MAX_ITERATIONS = 1000000;

    @Override
    public Vector solve(LinearSystem linearSystem, Factory factory) {
        int iteration;
        if (!this.suitableFor(linearSystem)) {
            throw new IllegalArgumentException();
        }
        Matrix a = linearSystem.coefficientsMatrix().copy();
        Vector b = linearSystem.rightHandVector();
        for (int i = 0; i < a.rows(); ++i) {
            for (int j = 0; j < a.columns(); ++j) {
                if (i == j) continue;
                a.update(i, j, Matrices.asDivFunction(a.get(i, i)));
            }
        }
        Vector current = factory.createVector(linearSystem.variables());
        for (iteration = 0; iteration < 1000000 && !linearSystem.isSolution(current); ++iteration) {
            for (int i = 0; i < a.rows(); ++i) {
                double summand = b.get(i) / a.get(i, i);
                for (int j = 0; j < a.columns(); ++j) {
                    if (i == j) continue;
                    summand -= a.get(i, j) * current.get(j);
                }
                current.set(i, summand);
            }
        }
        if (iteration == 1000000) {
            throw new IllegalArgumentException();
        }
        return current;
    }

    @Override
    public boolean suitableFor(LinearSystem linearSystem) {
        Matrix a = linearSystem.coefficientsMatrix();
        for (int i = 0; i < a.rows(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < a.columns(); ++j) {
                if (i == j) continue;
                sum += Math.abs(a.get(i, j));
            }
            if (!(sum > Math.abs(a.get(i, i)) - Matrices.EPS)) continue;
            return false;
        }
        return true;
    }
}

