/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ProcAddressTable {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static boolean DEBUG;
    protected static String DEBUG_PREFIX;
    protected static int debugNum;
    private final FunctionAddressResolver resolver;

    public ProcAddressTable() {
        this(new One2OneResolver());
    }

    public ProcAddressTable(FunctionAddressResolver functionAddressResolver) {
        this.resolver = functionAddressResolver;
    }

    public void reset(DynamicLookupHelper dynamicLookupHelper) throws RuntimeException {
        if (null == dynamicLookupHelper) {
            throw new RuntimeException("Passed null DynamicLookupHelper");
        }
        PrintStream printStream = ProcAddressTable.getDebugOutStream();
        if (DEBUG) {
            printStream.println(this.getClass().getName() + ".reset()");
        }
        Field[] fieldArray = this.getClass().getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!this.isAddressField(string)) continue;
            String string2 = this.fieldToFunctionName(string);
            this.setEntry(fieldArray[i], string2, dynamicLookupHelper);
        }
        if (DEBUG) {
            printStream.flush();
            if (DEBUG_PREFIX != null) {
                printStream.close();
            }
        }
    }

    public void initEntry(String string, DynamicLookupHelper dynamicLookupHelper) {
        Field field = this.fieldForFunction(string);
        this.setEntry(field, string, dynamicLookupHelper);
    }

    protected void setEntry(Field field, String string, DynamicLookupHelper dynamicLookupHelper) {
        try {
            assert (field.getType() == Long.TYPE);
            long l = this.resolver.resolve(string, dynamicLookupHelper);
            field.setLong(this, l);
            if (DEBUG) {
                ProcAddressTable.getDebugOutStream().println("  " + field.getName() + " -> 0x" + Long.toHexString(l));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not get proc address for method \"" + string + "\": Couldn't set value of field \"" + field, exception);
        }
    }

    protected String fieldToFunctionName(String string) {
        return string.substring(PROCADDRESS_VAR_PREFIX.length());
    }

    protected Field fieldForFunction(String string) {
        try {
            return this.getClass().getField(PROCADDRESS_VAR_PREFIX + string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(this.getClass().getName() + " has no entry for the function '" + string + "'.", noSuchFieldException);
        }
    }

    protected boolean isAddressField(String string) {
        return string.startsWith(PROCADDRESS_VAR_PREFIX);
    }

    protected static PrintStream getDebugOutStream() {
        PrintStream printStream = null;
        if (DEBUG) {
            if (DEBUG_PREFIX != null) {
                try {
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(DEBUG_PREFIX + File.separatorChar + "procaddresstable-" + ++debugNum + ".txt")));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    printStream = System.err;
                }
            } else {
                printStream = System.err;
            }
        }
        return printStream;
    }

    public Map<String, Long> toMap() {
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
        Field[] fieldArray = this.getClass().getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                String string = fieldArray[i].getName();
                if (!this.isAddressField(string)) continue;
                treeMap.put(this.fieldToFunctionName(string), (Long)fieldArray[i].get(this));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return treeMap;
    }

    public boolean isFunctionAvailable(String string) {
        try {
            return this.getAddressFor(string) != 0L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public long getAddressFor(String string) {
        Field field = this.fieldForFunction(string);
        try {
            return field.getLong(this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public Set<String> getNullPointerFunctions() {
        Map<String, Long> map = this.toMap();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            long l = entry.getValue();
            if (l != 0L) continue;
            linkedHashSet.add(entry.getKey());
        }
        return linkedHashSet;
    }

    public String toString() {
        return this.getClass().getName() + "" + this.toMap();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean bl = DEBUG = System.getProperty("jogamp.debug.ProcAddressHelper") != null;
                if (DEBUG) {
                    DEBUG_PREFIX = System.getProperty("jogamp.debug.ProcAddressHelper.prefix");
                }
                return null;
            }
        });
    }

    private static class One2OneResolver
    implements FunctionAddressResolver {
        private One2OneResolver() {
        }

        @Override
        public long resolve(String string, DynamicLookupHelper dynamicLookupHelper) {
            return dynamicLookupHelper.dynamicLookupFunction(string);
        }
    }
}

