/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.experiments.langid;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.io.FileUtils;
import org.openimaj.text.nlp.language.LanguageDetector;
import org.openimaj.twitter.collection.MemoryTwitterStatusList;
import org.openimaj.twitter.experiments.langid.TrueLanguageTwitterStatus;
import org.openimaj.util.pair.IndependentPair;

public class TrueLanguageExperiment {
    String[] inputFiles = new String[]{"dev-out-r", "trn-out-r", "tst-out-r"};
    private ArrayList<TrueLanguageTwitterStatus> inputStatusLists;
    private HashMap<String, IndependentPair<Float, Long>> scores;

    public void prepareExperiment() throws IOException {
        this.inputStatusLists = new ArrayList();
        for (String input : this.inputFiles) {
            File inputFile = FileUtils.copyStreamToFile((InputStream)TrueLanguageExperiment.class.getResourceAsStream(input), (File)File.createTempFile(input, ".txt"));
            MemoryTwitterStatusList<TrueLanguageTwitterStatus> list = MemoryTwitterStatusList.read(inputFile, TrueLanguageTwitterStatus.class);
            this.inputStatusLists.addAll(list);
            inputFile.delete();
        }
    }

    public void doExperiment() throws IOException {
        this.scores = new HashMap();
        IndependentPair totalScore = IndependentPair.pair((Object)Float.valueOf(0.0f), (Object)0L);
        this.scores.put("total", (IndependentPair<Float, Long>)totalScore);
        LanguageDetector languageDetector = new LanguageDetector();
        for (TrueLanguageTwitterStatus trueLanguageTwitterStatus : this.inputStatusLists) {
            LanguageDetector.WeightedLocale detected = languageDetector.classify(trueLanguageTwitterStatus.text);
            IndependentPair currentScore = this.scores.get(detected.language);
            if (currentScore == null) {
                currentScore = IndependentPair.pair((Object)Float.valueOf(0.0f), (Object)0L);
                this.scores.put(detected.language, (IndependentPair<Float, Long>)currentScore);
            }
            if (detected.language.equals(trueLanguageTwitterStatus.lang_true)) {
                currentScore.setFirstObject((Object)Float.valueOf(((Float)currentScore.firstObject()).floatValue() + 1.0f));
                totalScore.setFirstObject((Object)Float.valueOf(((Float)totalScore.firstObject()).floatValue() + 1.0f));
            }
            currentScore.setSecondObject((Object)((Long)currentScore.secondObject() + 1L));
            totalScore.setSecondObject((Object)((Long)totalScore.secondObject() + 1L));
        }
        for (Map.Entry entry : this.scores.entrySet()) {
            System.out.println((String)entry.getKey() + ":" + ((Float)((IndependentPair)entry.getValue()).firstObject()).floatValue() / (float)((Long)((IndependentPair)entry.getValue()).secondObject()).longValue());
        }
        System.out.println("Total score:" + ((Float)totalScore.firstObject()).floatValue() / (float)((Long)totalScore.secondObject()).longValue());
    }

    public static void main(String[] args) throws IOException {
        TrueLanguageExperiment exp = new TrueLanguageExperiment();
        exp.prepareExperiment();
        exp.doExperiment();
    }
}

