/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.collection;

import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.USMFStatus;
import org.openimaj.twitter.collection.TwitterStatusList;
import org.openimaj.util.list.AbstractStreamBackedList;

public class StreamTwitterStatusList<T extends USMFStatus>
extends AbstractStreamBackedList<T>
implements TwitterStatusList<T> {
    private Class<? extends GeneralJSON> seedClass = USMFStatus.class;

    protected StreamTwitterStatusList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, Class<T> clazz, String charset) throws IOException {
        super(stream, size, isBinary, headerLength, recordLength, clazz, charset);
    }

    protected StreamTwitterStatusList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, Class<? extends GeneralJSON> inputClass, Class<T> instanceClass, String charset) throws IOException {
        super(stream, size, isBinary, headerLength, recordLength, instanceClass, charset);
        this.seedClass = inputClass;
    }

    protected StreamTwitterStatusList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, Class<T> clazz) throws IOException {
        super(stream, size, isBinary, headerLength, recordLength, clazz);
    }

    protected T newElementInstance() {
        return (T)new USMFStatus(this.seedClass);
    }

    public static StreamTwitterStatusList<USMFStatus> read(InputStream stream, int nTweets) throws IOException {
        return StreamTwitterStatusList.read(new BufferedInputStream(stream), nTweets, USMFStatus.class);
    }

    public static StreamTwitterStatusList<USMFStatus> read(InputStream stream) throws IOException {
        return StreamTwitterStatusList.read(new BufferedInputStream(stream), -1, USMFStatus.class);
    }

    public static StreamTwitterStatusList<USMFStatus> read(InputStream stream, int nTweets, String charset) throws IOException {
        return StreamTwitterStatusList.read(new BufferedInputStream(stream), nTweets, USMFStatus.class, charset);
    }

    public static StreamTwitterStatusList<USMFStatus> read(InputStream stream, String charset) throws IOException {
        return StreamTwitterStatusList.read(new BufferedInputStream(stream), -1, USMFStatus.class, charset);
    }

    public static <T extends USMFStatus> StreamTwitterStatusList<T> read(InputStream stream, int nTweets, Class<T> clazz) throws IOException {
        return StreamTwitterStatusList.read(new BufferedInputStream(stream), nTweets, clazz);
    }

    public static StreamTwitterStatusList<USMFStatus> readUSMF(InputStream stream, Class<? extends GeneralJSON> generalJSON) throws IOException {
        StreamTwitterStatusList<USMFStatus> a = StreamTwitterStatusList.read((InputStream)new BufferedInputStream(stream), -1, generalJSON, USMFStatus.class);
        return a;
    }

    public static StreamTwitterStatusList<USMFStatus> readUSMF(InputStream stream, Class<? extends GeneralJSON> generalJSON, String charset) throws IOException {
        StreamTwitterStatusList<USMFStatus> a = StreamTwitterStatusList.read(new BufferedInputStream(stream), -1, generalJSON, USMFStatus.class, charset);
        return a;
    }

    public static StreamTwitterStatusList<USMFStatus> readUSMF(InputStream stream, int nTweets, Class<? extends GeneralJSON> generalJSON, String charset) throws IOException {
        StreamTwitterStatusList<USMFStatus> a = StreamTwitterStatusList.read(new BufferedInputStream(stream), -1, generalJSON, USMFStatus.class, charset);
        return a;
    }

    public static StreamTwitterStatusList<USMFStatus> readUSMF(InputStream stream, int nTweets, Class<? extends GeneralJSON> generalJSON) throws IOException {
        StreamTwitterStatusList<USMFStatus> a = StreamTwitterStatusList.read((InputStream)new BufferedInputStream(stream), nTweets, generalJSON, USMFStatus.class);
        return a;
    }

    public static <T extends USMFStatus> StreamTwitterStatusList<T> read(InputStream stream, int nTweets, Class<? extends GeneralJSON> inputClass, Class<T> instanceClass) throws IOException {
        StreamTwitterStatusList<T> a = StreamTwitterStatusList.read(new BufferedInputStream(stream), nTweets, inputClass, instanceClass, "UTF-8");
        return a;
    }

    public static <T extends USMFStatus> StreamTwitterStatusList<T> read(BufferedInputStream stream, int nTweets, Class<? extends GeneralJSON> inputClass, Class<T> instanceClass, String charset) throws IOException {
        boolean isBinary = false;
        int size = nTweets;
        int headerLength = 0;
        int recordLength = -1;
        return new StreamTwitterStatusList<T>(stream, size, isBinary, headerLength, recordLength, inputClass, instanceClass, charset);
    }

    public static <T extends USMFStatus> StreamTwitterStatusList<T> read(BufferedInputStream stream, int nTweets, Class<T> clz) throws IOException {
        boolean isBinary = false;
        int size = nTweets;
        int headerLength = 0;
        int recordLength = -1;
        return new StreamTwitterStatusList<T>(stream, size, isBinary, headerLength, recordLength, clz);
    }

    public static <T extends USMFStatus> StreamTwitterStatusList<T> read(BufferedInputStream stream, int nTweets, Class<T> clazz, String charset) throws IOException {
        boolean isBinary = false;
        int size = nTweets;
        int headerLength = 0;
        int recordLength = -1;
        return new StreamTwitterStatusList<T>(stream, size, isBinary, headerLength, recordLength, clazz, charset);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            USMFStatus k = (USMFStatus)iterator.next();
            k.writeASCII(out);
            out.println();
        }
    }

    public String asciiHeader() {
        return "";
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] binaryHeader() {
        throw new UnsupportedOperationException();
    }
}

