/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.collection;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.openimaj.io.FileUtils;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.USMFStatus;
import org.openimaj.twitter.collection.TwitterStatusList;
import org.openimaj.util.list.AbstractFileBackedList;

public class FileTwitterStatusList<T extends USMFStatus>
extends AbstractFileBackedList<T>
implements TwitterStatusList<T> {
    private Class<? extends GeneralJSON> seedClass = null;
    private static final long serialVersionUID = -785707085718120105L;

    protected FileTwitterStatusList(int size, File file, String charset, Class<T> clazz) {
        super(size, false, 0, -1, file, clazz, charset);
    }

    protected FileTwitterStatusList(int size, File file, String charset, Class<T> clazz, Class<? extends GeneralJSON> seedClass) {
        super(size, false, 0, -1, file, clazz, charset);
        this.seedClass = seedClass;
    }

    protected FileTwitterStatusList(int size, File file, Class<T> clazz) {
        super(size, false, 0, -1, file, clazz);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        for (int i = 0; i < this.size; ++i) {
            ((USMFStatus)this.get(i)).writeASCII(out);
            out.println();
        }
    }

    protected T newElementInstance() {
        if (this.seedClass == null) {
            return (T)new USMFStatus();
        }
        return (T)new USMFStatus(this.seedClass);
    }

    public String asciiHeader() {
        return "";
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f) throws IOException {
        int size = FileUtils.countLines((File)f);
        return new FileTwitterStatusList<USMFStatus>(size, f, USMFStatus.class);
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f, String charset) throws IOException {
        int size = FileUtils.countLines((File)f);
        return new FileTwitterStatusList<USMFStatus>(size, f, charset, USMFStatus.class);
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f, int size) throws IOException {
        return new FileTwitterStatusList<USMFStatus>(size, f, USMFStatus.class);
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f, String charset, int size) throws IOException {
        return new FileTwitterStatusList<USMFStatus>(size, f, charset, USMFStatus.class);
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f, String charset, Class<? extends GeneralJSON> generalJSON) {
        int size = FileUtils.countLines((File)f);
        return new FileTwitterStatusList<USMFStatus>(size, f, charset, USMFStatus.class, generalJSON);
    }

    public static FileTwitterStatusList<USMFStatus> readUSMF(File f, int size, String charset, Class<? extends GeneralJSON> generalJSON) {
        return new FileTwitterStatusList<USMFStatus>(size, f, charset, USMFStatus.class, generalJSON);
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] binaryHeader() {
        throw new UnsupportedOperationException();
    }

    protected AbstractFileBackedList<T> newInstance(int newSize, boolean isBinary, int newHeaderLength, int recordLength, File file) {
        return new FileTwitterStatusList<T>(newSize, file, this.charset, this.clz);
    }

    public static List<USMFStatus> readUSMF(File f, Class<? extends GeneralJSON> generalJSON) {
        int size = FileUtils.countLines((File)f);
        String charset = "UTF-8";
        return new FileTwitterStatusList<USMFStatus>(size, f, "UTF-8", USMFStatus.class, generalJSON);
    }
}

