/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openimaj.io.IOUtils;
import org.openimaj.twitter.GeneralJSON;

public class USMFStatus
extends GeneralJSON
implements Cloneable {
    private static final Logger logger = Logger.getLogger(USMFStatus.class);
    private transient Class<? extends GeneralJSON> generalJSONclass;
    public String service;
    public long id;
    public double[] geo;
    public String application;
    public String location;
    public String date;
    public String source;
    public String text;
    public String description;
    public ArrayList<String> keywords;
    public String category;
    public long duration;
    public int likes;
    public int dislikes;
    public int favorites;
    public int comments;
    public int rates;
    public int rating;
    public int min_rating;
    public int max_rating;
    public User user;
    public ArrayList<User> to_users;
    public User reply_to;
    public ArrayList<Link> links;
    public String country_code;
    private boolean invalid = false;

    public USMFStatus(Class<? extends GeneralJSON> generalJSONclass) {
        this.generalJSONclass = generalJSONclass;
        this.to_users = new ArrayList();
        this.links = new ArrayList();
        this.user = new User();
        this.keywords = new ArrayList();
    }

    public USMFStatus() {
        this.generalJSONclass = USMFStatus.class;
        this.to_users = new ArrayList();
        this.links = new ArrayList();
        this.user = new User();
        this.keywords = new ArrayList();
    }

    public Class<? extends GeneralJSON> getGeneralJSONClass() {
        return this.generalJSONclass;
    }

    public void setGeneralJSONClass(Class<? extends GeneralJSON> g) {
        this.generalJSONclass = g;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void readASCII(Scanner in) throws IOException {
        String line = in.nextLine();
        this.fillFromString(line);
    }

    public void fillFromString(String line) {
        GeneralJSON jsonInstance = null;
        try {
            jsonInstance = (GeneralJSON)IOUtils.newInstance(this.generalJSONclass);
            jsonInstance = jsonInstance.instanceFromString(line);
        }
        catch (Throwable e) {
            logger.debug((Object)("Error parsing USMF: " + e.getMessage()));
        }
        if (jsonInstance == null) {
            this.text = line;
        } else {
            jsonInstance.fillUSMF(this);
        }
        if (this.text == null && this.analysis.size() == 0) {
            this.invalid = true;
            return;
        }
        this.invalid = false;
    }

    @Override
    public GeneralJSON instanceFromString(String line) {
        GeneralJSON jsonInstance = null;
        try {
            jsonInstance = (GeneralJSON)gson.fromJson(line, this.generalJSONclass);
        }
        catch (Throwable e) {
            logger.debug((Object)("Error parsing USMF: " + e.getMessage()));
        }
        return jsonInstance;
    }

    private void fillFrom(USMFStatus read) {
        for (Field field : USMFStatus.class.getFields()) {
            if (!Modifier.isPublic(field.getModifiers())) continue;
            try {
                field.set(this, field.get(read));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.text;
    }

    public String toJson() {
        return gson.toJson((Object)this, this.getClass());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof USMFStatus)) {
            return false;
        }
        USMFStatus status = (USMFStatus)obj;
        boolean equal = true;
        equal = this.equalNonAnalysed(status);
        if (!equal) {
            return false;
        }
        equal = this.equalAnalysed(status);
        return equal;
    }

    private boolean equalAnalysed(USMFStatus status) {
        Map thatanal = status.analysis;
        Map thisanal = this.analysis;
        for (String key : thatanal.keySet()) {
            Object thatobj;
            if (!thisanal.containsKey(key)) {
                return false;
            }
            Object thisobj = thisanal.get(key);
            if (thisobj.equals(thatobj = thatanal.get(key))) continue;
            return false;
        }
        return true;
    }

    private boolean equalNonAnalysed(USMFStatus that) {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (field.getName() == "analysis" || Modifier.isStatic(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                Object thisval = field.get(this);
                Object thatval = field.get(that);
                if (thisval == null || thatval == null) {
                    if (thisval == null && thatval == null) continue;
                    return false;
                }
                if (!thisval.equals(thatval)) continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public USMFStatus clone() {
        return this.clone(USMFStatus.class);
    }

    public <T extends USMFStatus> T clone(Class<T> clazz) {
        return (T)((USMFStatus)gson.fromJson(gson.toJson((Object)this), clazz));
    }

    public DateTime createdAt() throws ParseException {
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy");
        if (this.date == null) {
            return null;
        }
        return parser.parseDateTime(this.date);
    }

    @Override
    public void fillUSMF(USMFStatus status) {
        status.fillFrom(this);
    }

    @Override
    public void fromUSMF(USMFStatus status) {
        this.fillFrom(status);
    }

    public static class Link {
        public String title;
        public String thumbnail;
        public String href;

        public boolean equals(Object obj) {
            if (obj instanceof Link) {
                Link in = (Link)obj;
                for (Field field : Link.class.getFields()) {
                    try {
                        if (field.get(this) == null && field.get(in) == null) continue;
                        if (field.get(this) == null || field.get(in) == null) {
                            return false;
                        }
                        if (field.get(this).equals(field.get(in))) continue;
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class User {
        public String name;
        public String real_name;
        public double id;
        public String language;
        public double utc;
        public double[] geo;
        public String description;
        public String avatar;
        public String location;
        public double subscribers;
        public int subscriptions;
        public double postings;
        public String profile;
        public String website;

        public boolean equals(Object obj) {
            if (obj instanceof User) {
                User in = (User)obj;
                for (Field field : User.class.getFields()) {
                    try {
                        if (field.get(this) == null && field.get(in) == null) continue;
                        if (field.get(this) == null || field.get(in) == null) {
                            return false;
                        }
                        if (field.get(this).equals(field.get(in))) continue;
                        return false;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }
    }
}

