/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter;

import com.hp.hpl.jena.query.ParameterizedSparqlString;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.io.FileUtils;
import org.openimaj.rdf.utils.PQUtils;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.RDFAnalysisProvider;
import org.openimaj.twitter.USMFStatus;
import org.openjena.riot.SysRIOT;

public class GeneralJSONRDF
extends GeneralJSON {
    private static final String INSERT_ITEM_QUERY_FILE = "/org/openimaj/twitter/rdf/insert_usmf_query.sparql";
    private static final String DELETE_TM_NULL = "/org/openimaj/twitter/rdf/delete_null.sparql";
    private static final String LINK_INSERT_QUERY_FILE = "/org/openimaj/twitter/rdf/insert_usmf_links_query.sparql";
    private static final String KEYWORDS_INSERT_QUERY_FILE = "/org/openimaj/twitter/rdf/insert_usmf_keywords_query.sparql";
    private static final String TOUSERS_INSERT_QUERY_FILE = "/org/openimaj/twitter/rdf/insert_usmf_touser_query.sparql";
    private static Map<String, String> queryCache;
    private Model m;
    private Resource eventIRI;
    private static String baseModelString;
    private static final Map<String, RDFAnalysisProvider> providers;

    public static void registerRDFAnalysisProvider(String analysis, RDFAnalysisProvider analysisProvider) {
        analysisProvider.init();
        providers.put(analysis, analysisProvider);
    }

    public void readASCII(Scanner in) throws IOException {
        StringBuffer b = new StringBuffer();
        while (in.hasNext()) {
            b.append(in.next());
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(b.toString().getBytes("UTF-8"));
        this.m = ModelFactory.createDefaultModel();
        this.m.read((InputStream)stream, "", "NTRIPLES");
        this.m.close();
    }

    @Override
    public void fillUSMF(USMFStatus status) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    private static String queryCache(String queryFile) {
        String q;
        if (queryCache == null) {
            queryCache = new HashMap<String, String>();
        }
        if ((q = queryCache.get(queryFile)) == null) {
            q = GeneralJSONRDF.readQuery(queryFile);
            queryCache.put(queryFile, q);
        }
        return q;
    }

    private static String readQuery(String qf) {
        try {
            return FileUtils.readall((InputStream)GeneralJSONRDF.class.getResourceAsStream(qf));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void fromUSMF(USMFStatus status) {
        this.prepareModel();
        ParameterizedSparqlString pss = PQUtils.constructPQ((String)GeneralJSONRDF.queryCache(INSERT_ITEM_QUERY_FILE), (Model)this.m);
        this.eventIRI = this.m.createResource(this.generateSocialEventIRI(status));
        PQUtils.setPSSResource((ParameterizedSparqlString)pss, (String)Variables.SOCIAL_EVENT.name, (Resource)this.eventIRI);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.SERVICE.name, (String)status.service);
        this.addUserParameters(pss, status.user, status);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.SOURCE_URL.name, (String)status.source);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.TEXT.name, (String)status.text);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.DESC.name, (String)status.description);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.CAT.name, (String)status.category);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.FAV.name, (int)status.favorites);
        UpdateAction.execute((UpdateRequest)pss.asUpdate(), (Model)this.m);
        pss = PQUtils.constructPQ((String)GeneralJSONRDF.readQuery(TOUSERS_INSERT_QUERY_FILE), (Model)this.m);
        for (USMFStatus.User user : status.to_users) {
            PQUtils.setPSSResource((ParameterizedSparqlString)pss, (String)Variables.SOCIAL_EVENT.name, (Resource)this.eventIRI);
            this.addUserParameters(pss, user, status);
            UpdateAction.execute((UpdateRequest)pss.asUpdate(), (Model)this.m);
            pss.clearParams();
        }
        pss = PQUtils.constructPQ((String)GeneralJSONRDF.readQuery(LINK_INSERT_QUERY_FILE), (Model)this.m);
        PQUtils.setPSSResource((ParameterizedSparqlString)pss, (String)Variables.SOCIAL_EVENT.name, (Resource)this.eventIRI);
        for (USMFStatus.Link link : status.links) {
            PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.LINK.name, (String)link.href);
            UpdateAction.execute((UpdateRequest)pss.asUpdate(), (Model)this.m);
        }
        pss = PQUtils.constructPQ((String)GeneralJSONRDF.readQuery(KEYWORDS_INSERT_QUERY_FILE), (Model)this.m);
        PQUtils.setPSSResource((ParameterizedSparqlString)pss, (String)Variables.SOCIAL_EVENT.name, (Resource)this.eventIRI);
        for (String string : status.keywords) {
            PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.KEYWORD.name, (String)string);
            UpdateAction.execute((UpdateRequest)pss.asUpdate(), (Model)this.m);
        }
        this.cleanupModel();
        status.fillAnalysis(this);
    }

    private void cleanupModel() {
        UpdateRequest del = PQUtils.constructPQ((String)GeneralJSONRDF.readQuery(DELETE_TM_NULL), (Model)this.m).asUpdate();
        UpdateAction.execute((UpdateRequest)del, (Model)this.m);
    }

    private void addUserParameters(ParameterizedSparqlString pss, USMFStatus.User user, USMFStatus status) {
        PQUtils.setPSSIri((ParameterizedSparqlString)pss, (String)Variables.USER.name, (String)this.createUserIRI(status, user));
        PQUtils.setPSSIri((ParameterizedSparqlString)pss, (String)Variables.PERSON.name, (String)this.createPersonIRI(status, user));
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.PERSON_NAME.name, (String)user.real_name);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.PERSON_LOC.name, (String)user.location);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String[])new String[]{Variables.PERSON_LAT.name, Variables.PERSON_LONG.name}, (double[])user.geo);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_NAME.name, (String)user.name);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_ID.name, (double)user.id);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_LANG.name, (String)user.language);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.PERSON_LANG.name, (String)user.language);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_DESC.name, (String)user.description);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_AVATAR.name, (String)user.avatar);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_SITE.name, (String)user.website);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_PROF.name, (String)user.profile);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_FOLLOWERS.name, (double)user.subscribers);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_FOLLOWING.name, (int)user.subscriptions);
        PQUtils.setPSSLiteral((ParameterizedSparqlString)pss, (String)Variables.USER_POSTS.name, (double)user.postings);
    }

    @Override
    public void writeASCIIAnalysis(PrintWriter outputWriter, List<String> selectiveAnalysis, List<String> selectiveStatus) {
        if (selectiveAnalysis == null) {
            selectiveAnalysis = new ArrayList<String>();
            selectiveAnalysis.addAll(this.analysis.keySet());
        }
        for (String ana : selectiveAnalysis) {
            RDFAnalysisProvider prov = providers.get(ana);
            if (prov == null) continue;
            prov.addAnalysis(this.m, this.eventIRI, this);
        }
        this.m.write((Writer)outputWriter, "N-TRIPLES");
    }

    private String createUserIRI(USMFStatus status, USMFStatus.User user) {
        return String.format("%s%s/user/%s", this.m.getNsPrefixURI("tm"), status.service, (long)user.id);
    }

    private String createPersonIRI(USMFStatus status, USMFStatus.User user) {
        return String.format("%s%s/person/%s", this.m.getNsPrefixURI("tm"), status.service, (long)user.id);
    }

    private String generateSocialEventIRI(USMFStatus status) {
        return String.format("%s%s/%s", this.m.getNsPrefixURI("tm"), status.service, status.id);
    }

    private synchronized void prepareModel() {
        this.m = ModelFactory.createDefaultModel();
        this.m.read((Reader)new StringReader(baseModelString), "");
    }

    @Override
    public GeneralJSON instanceFromString(String line) {
        GeneralJSONRDF jsonInstance = null;
        try {
            jsonInstance = new GeneralJSONRDF();
            jsonInstance.m.read((Reader)new StringReader(line), "");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return jsonInstance;
    }

    static {
        SysRIOT.wireIntoJena();
        try {
            baseModelString = FileUtils.readall((InputStream)GeneralJSONRDF.class.getResourceAsStream("rdf/base_usmf.rdf"));
            System.out.println("Read in base model!");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        providers = new HashMap<String, RDFAnalysisProvider>();
    }

    static enum Variables {
        SERVICE("service"),
        SOCIAL_EVENT("socialEvent"),
        USER("user"),
        PERSON("person"),
        PERSON_NAME("realname"),
        PERSON_LOC("location"),
        PERSON_LAT("lat"),
        PERSON_LONG("long"),
        USER_NAME("username"),
        USER_ID("osnid"),
        USER_LANG("userlanguage"),
        PERSON_LANG("personlanguage"),
        USER_DESC("description"),
        USER_AVATAR("useravatar"),
        USER_SITE("website"),
        USER_PROF("profile"),
        USER_FOLLOWERS("subscribers"),
        USER_FOLLOWING("subscriptions"),
        SOURCE_URL("sourceURL"),
        TEXT("text"),
        DESC("description"),
        CAT("category"),
        FAV("favourites"),
        USER_POSTS("postings"),
        LINK("link"),
        KEYWORD("keyword");

        public String name;

        private Variables(String name) {
            this.name = name;
        }
    }
}

