/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.sketch.countmin;

import gnu.trove.map.hash.TIntIntHashMap;
import org.openimaj.ml.sketch.SummarySketcher;
import org.openimaj.util.hash.StringMurmurHashFunction;
import org.openimaj.util.hash.StringMurmurHashFunctionFactory;
import org.openimaj.util.pair.IndependentPair;

public class CountMin
implements SummarySketcher<String, Integer> {
    private FunctionHashPair[] maps;
    private int nwords;

    public CountMin(int ntables, int nwords) {
        this.maps = new FunctionHashPair[ntables];
        this.nwords = nwords;
        StringMurmurHashFunctionFactory fact = new StringMurmurHashFunctionFactory();
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = new FunctionHashPair(fact.create(), new TIntIntHashMap());
        }
    }

    @Override
    public void update(String data, Integer value) {
        for (FunctionHashPair map : this.maps) {
            int hash = ((StringMurmurHashFunction)map.firstObject()).computeHashCode(data);
            int loc = Math.abs(hash) % this.nwords;
            ((TIntIntHashMap)map.secondObject()).adjustOrPutValue(loc, value.intValue(), value.intValue());
        }
    }

    @Override
    public Integer query(String data) {
        int min = -1;
        for (FunctionHashPair map : this.maps) {
            int hash = ((StringMurmurHashFunction)map.firstObject()).computeHashCode(data);
            int loc = Math.abs(hash) % this.nwords;
            int v = ((TIntIntHashMap)map.secondObject()).get(loc);
            if (min != -1 && min <= v) continue;
            min = v;
        }
        return min;
    }

    private static class FunctionHashPair
    extends IndependentPair<StringMurmurHashFunction, TIntIntHashMap> {
        public FunctionHashPair(StringMurmurHashFunction func, TIntIntHashMap map) {
            super((Object)func, (Object)map);
        }
    }
}

