/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.sketch.bloom;

import gnu.trove.map.hash.TIntIntHashMap;
import org.openimaj.ml.sketch.SummarySketcher;
import org.openimaj.util.hash.StringMurmurHashFunction;
import org.openimaj.util.hash.StringMurmurHashFunctionFactory;

public class Bloom
implements SummarySketcher<String, Boolean> {
    private StringMurmurHashFunction[] maps;
    private TIntIntHashMap table;
    private int nwords;

    public Bloom(int ntables, int nwords) {
        this.maps = new StringMurmurHashFunction[ntables];
        StringMurmurHashFunctionFactory fact = new StringMurmurHashFunctionFactory();
        for (int i = 0; i < this.maps.length; ++i) {
            this.maps[i] = fact.create();
        }
        this.nwords = nwords;
        this.table = new TIntIntHashMap(nwords);
    }

    @Override
    public void update(String data, Boolean value) {
        for (StringMurmurHashFunction map : this.maps) {
            int hash = map.computeHashCode(data);
            int loc = Math.abs(hash) % this.nwords;
            this.table.put(loc, 1);
        }
    }

    @Override
    public Boolean query(String data) {
        boolean found = false;
        for (StringMurmurHashFunction map : this.maps) {
            int hash = map.computeHashCode(data);
            int loc = Math.abs(hash) % this.nwords;
            boolean bl = found = this.table.get(loc) == 1;
            if (!found) continue;
            return found;
        }
        return found;
    }
}

