/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.tools.twitter.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Scanner;
import org.openimaj.hadoop.tools.twitter.utils.WordDFIDF;
import org.openimaj.io.ReadWriteableASCII;
import org.openimaj.ml.timeseries.TimeSeriesArithmaticOperator;
import org.openimaj.ml.timeseries.series.ConcreteTimeSeries;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;
import org.openimaj.ml.timeseries.series.DoubleTimeSeriesProvider;
import org.openimaj.util.pair.IndependentPair;

public class WordDFIDFTimeSeries
extends ConcreteTimeSeries<WordDFIDF, WordDFIDFTimeSeries>
implements TimeSeriesArithmaticOperator<WordDFIDF, WordDFIDFTimeSeries>,
DoubleTimeSeriesProvider,
ReadWriteableASCII {
    public WordDFIDFTimeSeries newInstance() {
        return new WordDFIDFTimeSeries();
    }

    public WordDFIDF zero() {
        return new WordDFIDF();
    }

    public WordDFIDF sum() {
        WordDFIDF ret = this.zero();
        for (WordDFIDF time : (WordDFIDF[])this.getData()) {
            ret.tf += time.tf;
            ret.wf += time.wf;
            ret.Ttf = time.Ttf;
            ret.Twf = time.Twf;
        }
        return ret;
    }

    public DoubleTimeSeries doubleTimeSeries() {
        long[] times = this.getTimes();
        double[] values = new double[times.length];
        WordDFIDF[] current = (WordDFIDF[])this.getData();
        int i = 0;
        for (WordDFIDF wordDFIDF : current) {
            values[i++] = wordDFIDF.dfidf();
        }
        return new DoubleTimeSeries(times, values);
    }

    public void readASCII(Scanner in) throws IOException {
        int count = in.nextInt();
        for (int i = 0; i < count; ++i) {
            WordDFIDF instance = new WordDFIDF();
            instance.readASCII(in);
            this.add(instance.timeperiod, instance);
        }
    }

    public String asciiHeader() {
        return "";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.size() + " ");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IndependentPair i = (IndependentPair)iterator.next();
            ((WordDFIDF)i.secondObject()).writeASCII(out);
            out.print(" ");
        }
    }
}

