/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.tools.twitter.utils;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.hadoop.tools.twitter.utils.WriteableStringIntPair;
import org.openimaj.io.ReadWriteableBinary;

public class TweetCountWordMap
implements ReadWriteableBinary {
    int ntweets;
    public static final int INVALID_TWEET_COUNT = -1;
    TObjectIntHashMap<String> wordMap;

    public TweetCountWordMap() {
        this.ntweets = 0;
        this.wordMap = new TObjectIntHashMap();
    }

    public TweetCountWordMap(int ntweets, TObjectIntHashMap<String> wordMap) {
        this.ntweets = ntweets;
        this.wordMap = wordMap;
    }

    public void readBinary(DataInput in) throws IOException {
        WriteableStringIntPair tweetPair = new WriteableStringIntPair();
        tweetPair.readBinary(in);
        this.ntweets = (Integer)tweetPair.secondObject();
        int nWords = in.readInt();
        for (int i = 0; i < nWords; ++i) {
            WriteableStringIntPair wordPair = new WriteableStringIntPair();
            wordPair.readBinary(in);
            this.wordMap.put(wordPair.firstObject(), ((Integer)wordPair.secondObject()).intValue());
        }
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public void writeBinary(final DataOutput out) throws IOException {
        new WriteableStringIntPair("ntweets", this.ntweets).writeBinary(out);
        out.writeInt(this.wordMap.size());
        this.wordMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String word, int count) {
                try {
                    new WriteableStringIntPair(word, count).writeBinary(out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
        });
    }

    public boolean equals(Object other) {
        boolean eq;
        if (!(other instanceof TweetCountWordMap)) {
            return false;
        }
        final TweetCountWordMap that = (TweetCountWordMap)other;
        boolean bl = eq = this.ntweets == that.ntweets;
        if (!eq) {
            return false;
        }
        return this.wordMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String arg0, int arg1) {
                return that.wordMap.get((Object)arg0) == arg1;
            }
        });
    }

    public TObjectIntHashMap<String> getTweetWordMap() {
        return this.wordMap;
    }

    public void incrementTweetCount(int i) {
        this.ntweets += i;
    }

    public void combine(TweetCountWordMap that) {
        this.ntweets += that.ntweets;
        if (this.wordMap == null || that.wordMap == null) {
            return;
        }
        that.wordMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String word, int count) {
                TweetCountWordMap.this.wordMap.adjustOrPutValue((Object)word, count, count);
                return true;
            }
        });
    }

    public long getNTweets() {
        return this.ntweets;
    }

    public void setNTweets(int ntweets) {
        this.ntweets = ntweets;
    }
}

