/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

public class AudioFormat {
    private int nChannels = 0;
    private int nBits = 0;
    private double sampleRateKHz = 0.0;
    private boolean isSigned = true;
    private boolean isBigEndian = false;

    public AudioFormat(int nBits, double sampleRate, int nChannels) {
        this.nBits = nBits;
        this.sampleRateKHz = sampleRate;
        this.setNumChannels(nChannels);
    }

    public int getNBits() {
        return this.nBits;
    }

    public AudioFormat setNBits(int nBits) {
        this.nBits = nBits;
        return this;
    }

    public double getSampleRateKHz() {
        return this.sampleRateKHz;
    }

    public AudioFormat setSampleRateKHz(double s) {
        this.sampleRateKHz = s;
        return this;
    }

    public AudioFormat setNumChannels(int nChannels) {
        this.nChannels = nChannels;
        return this;
    }

    public int getNumChannels() {
        return this.nChannels;
    }

    public AudioFormat setSigned(boolean isSigned) {
        this.isSigned = isSigned;
        return this;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public AudioFormat setBigEndian(boolean isBigEndian) {
        this.isBigEndian = isBigEndian;
        return this;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public String toString() {
        return "[Audio: " + this.getSampleRateKHz() + "KHz, " + this.getNBits() + "bit, " + this.getNumChannels() + " channel" + (this.getNumChannels() > 1 ? "s" : "") + ", " + (this.isSigned ? "signed" : "unsigned") + ", " + (this.isBigEndian ? "big-endian" : "little-endian") + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)obj;
            if (this.isBigEndian == af.isBigEndian && this.isSigned == af.isSigned && this.nChannels == af.nChannels && this.nBits == af.nBits && this.sampleRateKHz == af.sampleRateKHz) {
                return true;
            }
        }
        return false;
    }

    public AudioFormat clone() {
        AudioFormat af = new AudioFormat(this.getNBits(), this.getSampleRateKHz(), this.getNumChannels());
        af.setBigEndian(this.isBigEndian);
        af.setSigned(this.isSigned);
        return af;
    }

    public javax.sound.sampled.AudioFormat getJavaAudioFormat() {
        return new javax.sound.sampled.AudioFormat((int)this.getSampleRateKHz() * 1000, this.getNBits(), this.getNumChannels(), this.isSigned(), this.isBigEndian());
    }
}

