/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation.annotation.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.Key;
import org.jbibtex.StringValue;
import org.jbibtex.Value;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;

public class MockReference
implements InvocationHandler {
    private String[] author;
    private String title;
    private ReferenceType type;
    private String year;
    private String journal = "";
    private String booktitle = "";
    private String[] pages = new String[0];
    private String chapter = "";
    private String edition = "";
    private String url = "";
    private String note = "";
    private String[] editor = new String[0];
    private String institution = "";
    private String month = "";
    private String number = "";
    private String organization = "";
    private String publisher = "";
    private String school = "";
    private String series = "";
    private String volume = "";
    private String[] customData = new String[0];

    public MockReference(BibTeXEntry entry) {
        this.type = ReferenceType.getReferenceType(entry.getType().getValue());
        Map fields = entry.getFields();
        for (Map.Entry e : fields.entrySet()) {
            String ks = ((Key)e.getKey()).getValue();
            Value v = (Value)e.getValue();
            if (ks.equalsIgnoreCase("author")) {
                this.author = ((StringValue)v).getString().split(" and ");
                continue;
            }
            if (ks.equalsIgnoreCase("title")) {
                this.title = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("year")) {
                this.year = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("journal")) {
                this.journal = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("booktitle")) {
                this.booktitle = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("pages")) {
                this.pages = ((StringValue)v).getString().split(",|-|--");
                continue;
            }
            if (ks.equalsIgnoreCase("chapter")) {
                this.chapter = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("edition")) {
                this.edition = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("url")) {
                this.url = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("note")) {
                this.note = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("editor")) {
                this.editor = ((StringValue)v).getString().split(" and ");
                continue;
            }
            if (ks.equalsIgnoreCase("institution")) {
                this.institution = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("month")) {
                this.month = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("number")) {
                this.number = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("organization")) {
                this.organization = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("publisher")) {
                this.publisher = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("school")) {
                this.school = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("series")) {
                this.series = ((StringValue)v).getString();
                continue;
            }
            if (ks.equalsIgnoreCase("volume")) {
                this.volume = ((StringValue)v).getString();
                continue;
            }
            ArrayList<String> data = new ArrayList<String>();
            data.addAll(Arrays.asList(this.customData));
            if (v instanceof StringValue) {
                data.add(ks);
                data.add(((StringValue)v).getString());
            }
            this.customData = data.toArray(this.customData);
        }
    }

    public String[] author() {
        return this.author;
    }

    public String title() {
        return this.title;
    }

    public ReferenceType type() {
        return this.type;
    }

    public String year() {
        return this.year;
    }

    public String journal() {
        return this.journal;
    }

    public String booktitle() {
        return this.booktitle;
    }

    public String[] pages() {
        return this.pages;
    }

    public String chapter() {
        return this.chapter;
    }

    public String edition() {
        return this.edition;
    }

    public String url() {
        return this.url;
    }

    public String note() {
        return this.note;
    }

    public String[] editor() {
        return this.editor;
    }

    public String institution() {
        return this.institution;
    }

    public String month() {
        return this.month;
    }

    public String number() {
        return this.number;
    }

    public String organization() {
        return this.organization;
    }

    public String publisher() {
        return this.publisher;
    }

    public String school() {
        return this.school;
    }

    public String series() {
        return this.series;
    }

    public String volume() {
        return this.volume;
    }

    public String[] customData() {
        return this.customData;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method newmethod = this.getClass().getMethod(method.getName(), method.getParameterTypes());
        return newmethod.invoke((Object)this, args);
    }

    public Reference asReference() {
        return (Reference)Proxy.newProxyInstance(MockReference.class.getClassLoader(), new Class[]{Reference.class}, (InvocationHandler)this);
    }

    public static Reference makeReference(BibTeXEntry entry) {
        return new MockReference(entry).asReference();
    }
}

