/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.citation;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.References;

public class ReferenceListener {
    private static Set<Reference> references = new LinkedHashSet<Reference>();

    private static synchronized void addOpenIMAJReference() {
        try {
            Class<?> clz = ReferenceListener.class.getClassLoader().loadClass("org.openimaj.OpenIMAJ");
            ReferenceListener.addReference(clz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static synchronized void addReference(Reference r) {
        references.add(r);
    }

    public static void addReference(Class<?> clz) {
        References ann2;
        Reference ann = clz.getAnnotation(Reference.class);
        if (ann != null) {
            ReferenceListener.addReference(ann);
        }
        if ((ann2 = clz.getAnnotation(References.class)) != null) {
            for (Reference r : ann2.references()) {
                ReferenceListener.addReference(r);
            }
        }
        ReferenceListener.processPackage(clz);
    }

    private static void processPackage(Class<?> clz) {
        Package base = clz.getPackage();
        while (base != null) {
            String name;
            int dot;
            if (base.isAnnotationPresent(Reference.class)) {
                ReferenceListener.addReference(base.getAnnotation(Reference.class));
            }
            if (base.isAnnotationPresent(References.class)) {
                for (Reference r : base.getAnnotation(References.class).references()) {
                    ReferenceListener.addReference(r);
                }
            }
            if ((dot = (name = base.getName()).lastIndexOf(".")) < 0) break;
            base = Package.getPackage(name.substring(0, dot));
        }
    }

    public static void addReference(Class<?> clz, String methodName, String signature) {
        for (Method m : clz.getDeclaredMethods()) {
            References ann2;
            if (!m.getName().equals(methodName) || !m.toString().endsWith(signature)) continue;
            Reference ann = m.getAnnotation(Reference.class);
            if (ann != null) {
                ReferenceListener.addReference(ann);
            }
            if ((ann2 = m.getAnnotation(References.class)) == null) continue;
            for (Reference r : ann2.references()) {
                ReferenceListener.addReference(r);
            }
        }
        ReferenceListener.processPackage(clz);
    }

    public static synchronized Set<Reference> reset() {
        Set<Reference> oldRefs = references;
        references = new LinkedHashSet<Reference>();
        ReferenceListener.addOpenIMAJReference();
        return oldRefs;
    }

    public static synchronized Set<Reference> getReferences() {
        return new LinkedHashSet<Reference>(references);
    }

    public static void addReferences(Collection<Reference> refs) {
        references.addAll(refs);
    }

    static {
        ReferenceListener.addOpenIMAJReference();
    }
}

