/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public class JobContextImpl
implements JobContext {
    protected final JobConf conf;
    private JobID jobId;
    protected UserGroupInformation ugi;
    protected final Credentials credentials;

    public JobContextImpl(Configuration conf, JobID jobId) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.jobId = jobId;
        this.credentials = this.conf.getCredentials();
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    public void setJobID(JobID jobId) {
        this.jobId = jobId;
    }

    @Override
    public int getNumReduceTasks() {
        return this.conf.getNumReduceTasks();
    }

    @Override
    public Path getWorkingDirectory() throws IOException {
        return this.conf.getWorkingDirectory();
    }

    @Override
    public Class<?> getOutputKeyClass() {
        return this.conf.getOutputKeyClass();
    }

    @Override
    public Class<?> getOutputValueClass() {
        return this.conf.getOutputValueClass();
    }

    @Override
    public Class<?> getMapOutputKeyClass() {
        return this.conf.getMapOutputKeyClass();
    }

    @Override
    public Class<?> getMapOutputValueClass() {
        return this.conf.getMapOutputValueClass();
    }

    @Override
    public String getJobName() {
        return this.conf.getJobName();
    }

    @Override
    public boolean userClassesTakesPrecedence() {
        return this.conf.userClassesTakesPrecedence();
    }

    @Override
    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.inputformat.class", TextInputFormat.class);
    }

    @Override
    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.map.class", Mapper.class);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.combine.class", null);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.reduce.class", Reducer.class);
    }

    @Override
    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.outputformat.class", TextOutputFormat.class);
    }

    @Override
    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.partitioner.class", HashPartitioner.class);
    }

    @Override
    public RawComparator<?> getSortComparator() {
        return this.conf.getOutputKeyComparator();
    }

    @Override
    public String getJar() {
        return this.conf.getJar();
    }

    @Override
    public RawComparator<?> getCombinerKeyGroupingComparator() {
        return this.conf.getCombinerKeyGroupingComparator();
    }

    @Override
    public RawComparator<?> getGroupingComparator() {
        return this.conf.getOutputValueGroupingComparator();
    }

    @Override
    public boolean getJobSetupCleanupNeeded() {
        return this.conf.getBoolean("mapred.committer.job.setup.cleanup.needed", true);
    }

    @Override
    public boolean getSymlink() {
        return DistributedCache.getSymlink(this.conf);
    }

    @Override
    public Path[] getArchiveClassPaths() {
        return DistributedCache.getArchiveClassPaths(this.conf);
    }

    @Override
    public URI[] getCacheArchives() throws IOException {
        return DistributedCache.getCacheArchives(this.conf);
    }

    @Override
    public URI[] getCacheFiles() throws IOException {
        return DistributedCache.getCacheFiles(this.conf);
    }

    @Override
    public Path[] getLocalCacheArchives() throws IOException {
        return DistributedCache.getLocalCacheArchives(this.conf);
    }

    @Override
    public Path[] getLocalCacheFiles() throws IOException {
        return DistributedCache.getLocalCacheFiles(this.conf);
    }

    @Override
    public Path[] getFileClassPaths() {
        return DistributedCache.getFileClassPaths(this.conf);
    }

    @Override
    public String[] getArchiveTimestamps() {
        return this.conf.getStrings("mapred.cache.archives.timestamps");
    }

    @Override
    public String[] getFileTimestamps() {
        return this.conf.getStrings("mapred.cache.files.timestamps");
    }

    @Override
    public int getMaxMapAttempts() {
        return this.conf.getMaxMapAttempts();
    }

    @Override
    public int getMaxReduceAttempts() {
        return this.conf.getMaxReduceAttempts();
    }

    @Override
    public boolean getProfileEnabled() {
        return this.conf.getProfileEnabled();
    }

    @Override
    public String getProfileParams() {
        return this.conf.getProfileParams();
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.conf.getProfileTaskRange(isMap);
    }

    @Override
    public String getUser() {
        return this.conf.getUser();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }
}

