/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;

public class Cluster {
    private UserGroupInformation ugi;
    private Configuration conf;
    private Path stagingAreaDir = null;
    final Random rand = new Random();

    public Cluster(Configuration conf) throws IOException {
        this(null, conf);
    }

    public Cluster(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.conf = conf;
        this.ugi = UserGroupInformation.getCurrentUser();
    }

    public Path getStagingAreaDir() throws IOException, InterruptedException {
        if (this.stagingAreaDir == null) {
            Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            String user = ugi != null ? ugi.getShortUserName() + this.rand.nextInt() : "dummy" + this.rand.nextInt();
            return stagingRootDir.getFileSystem(this.conf).makeQualified(new Path(stagingRootDir, user + "/.staging"));
        }
        return this.stagingAreaDir;
    }

    public static enum JobTrackerStatus {
        INITIALIZING,
        RUNNING;

    }
}

