/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SkipBadRecords;
import org.apache.hadoop.mapred.pipes.Application;
import org.apache.hadoop.mapred.pipes.DownwardProtocol;
import org.apache.hadoop.mapred.pipes.Submitter;

class PipesMapRunner<K1 extends WritableComparable, V1 extends Writable, K2 extends WritableComparable, V2 extends Writable>
extends MapRunner<K1, V1, K2, V2> {
    private JobConf job;

    PipesMapRunner() {
    }

    @Override
    public void configure(JobConf job) {
        this.job = job;
        SkipBadRecords.setAutoIncrMapperProcCount(job, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RecordReader<K1, V1> input, OutputCollector<K2, V2> output, Reporter reporter) throws IOException {
        Application application = null;
        try {
            RecordReader<FloatWritable, NullWritable> fakeInput = !Submitter.getIsJavaRecordReader(this.job) && !Submitter.getIsJavaMapper(this.job) ? input : null;
            application = new Application(this.job, fakeInput, output, reporter, this.job.getOutputKeyClass(), this.job.getOutputValueClass());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("interrupted", ie);
        }
        DownwardProtocol downlink = application.getDownlink();
        boolean isJavaInput = Submitter.getIsJavaRecordReader(this.job);
        downlink.runMap(reporter.getInputSplit(), this.job.getNumReduceTasks(), isJavaInput);
        boolean skipping = this.job.getBoolean("mapred.skip.on", false);
        try {
            if (isJavaInput) {
                WritableComparable key = (WritableComparable)input.createKey();
                Writable value = (Writable)input.createValue();
                downlink.setInputTypes(key.getClass().getName(), value.getClass().getName());
                while (input.next((FloatWritable)key, (NullWritable)value)) {
                    downlink.mapItem(key, value);
                    if (!skipping) continue;
                    downlink.flush();
                }
                downlink.endOfInput();
            }
            application.waitForFinish();
        }
        catch (Throwable t) {
            application.abort(t);
        }
        finally {
            application.cleanup();
        }
    }
}

