/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.TaskAttemptID;

public class TaskCompletionEvent
implements Writable {
    private int eventId;
    private String taskTrackerHttp;
    private int taskRunTime;
    private TaskAttemptID taskId;
    Status status;
    boolean isMap = false;
    private int idWithinJob;
    public static final TaskCompletionEvent[] EMPTY_ARRAY = new TaskCompletionEvent[0];

    public TaskCompletionEvent() {
        this.taskId = new TaskAttemptID();
    }

    public TaskCompletionEvent(int eventId, TaskAttemptID taskId, int idWithinJob, boolean isMap, Status status, String taskTrackerHttp) {
        this.taskId = taskId;
        this.idWithinJob = idWithinJob;
        this.isMap = isMap;
        this.eventId = eventId;
        this.status = status;
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public int getEventId() {
        return this.eventId;
    }

    @Deprecated
    public String getTaskId() {
        return this.taskId.toString();
    }

    public TaskAttemptID getTaskAttemptId() {
        return this.taskId;
    }

    public Status getTaskStatus() {
        return this.status;
    }

    public String getTaskTrackerHttp() {
        return this.taskTrackerHttp;
    }

    public int getTaskRunTime() {
        return this.taskRunTime;
    }

    public void setTaskRunTime(int taskCompletionTime) {
        this.taskRunTime = taskCompletionTime;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    @Deprecated
    public void setTaskId(String taskId) {
        this.taskId = TaskAttemptID.forName(taskId);
    }

    public void setTaskID(TaskAttemptID taskId) {
        this.taskId = taskId;
    }

    public void setTaskStatus(Status status) {
        this.status = status;
    }

    public void setTaskTrackerHttp(String taskTrackerHttp) {
        this.taskTrackerHttp = taskTrackerHttp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Task Id : ");
        buf.append(this.taskId);
        buf.append(", Status : ");
        buf.append(this.status.name());
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(TaskCompletionEvent.class)) {
            TaskCompletionEvent event = (TaskCompletionEvent)o;
            return this.isMap == event.isMapTask() && this.eventId == event.getEventId() && this.idWithinJob == event.idWithinJob() && this.status.equals((Object)event.getTaskStatus()) && this.taskId.equals(event.getTaskAttemptId()) && this.taskRunTime == event.getTaskRunTime() && this.taskTrackerHttp.equals(event.getTaskTrackerHttp());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isMapTask() {
        return this.isMap;
    }

    public int idWithinJob() {
        return this.idWithinJob;
    }

    public void write(DataOutput out) throws IOException {
        this.taskId.write(out);
        WritableUtils.writeVInt((DataOutput)out, (int)this.idWithinJob);
        out.writeBoolean(this.isMap);
        WritableUtils.writeEnum((DataOutput)out, (Enum)this.status);
        WritableUtils.writeString((DataOutput)out, (String)this.taskTrackerHttp);
        WritableUtils.writeVInt((DataOutput)out, (int)this.taskRunTime);
        WritableUtils.writeVInt((DataOutput)out, (int)this.eventId);
    }

    public void readFields(DataInput in) throws IOException {
        this.taskId.readFields(in);
        this.idWithinJob = WritableUtils.readVInt((DataInput)in);
        this.isMap = in.readBoolean();
        this.status = (Status)WritableUtils.readEnum((DataInput)in, Status.class);
        this.taskTrackerHttp = WritableUtils.readString((DataInput)in);
        this.taskRunTime = WritableUtils.readVInt((DataInput)in);
        this.eventId = WritableUtils.readVInt((DataInput)in);
    }

    public static enum Status {
        FAILED,
        KILLED,
        SUCCEEDED,
        OBSOLETE,
        TIPFAILED;

    }
}

