/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.tools.MRZKFailoverController;

public class JobTrackerHAServiceTarget
extends HAServiceTarget {
    private static final Log LOG = LogFactory.getLog(JobTrackerHAServiceTarget.class);
    private final InetSocketAddress addr;
    private InetSocketAddress zkfcAddr;
    private NodeFencer fencer;
    private BadFencingConfigurationException fenceConfigError;
    private String logicalName;
    private String jtId;
    private final boolean autoFailoverEnabled;

    public JobTrackerHAServiceTarget(Configuration conf) {
        this(conf, HAUtil.getJobTrackerId(conf));
    }

    public JobTrackerHAServiceTarget(Configuration conf, String jtId) {
        int port;
        this.logicalName = HAUtil.getLogicalName(conf);
        this.jtId = jtId;
        JobConf targetConf = new JobConf(conf);
        HAUtil.setGenericConf(targetConf, this.logicalName, jtId, HAUtil.JOB_TRACKER_SPECIFIC_KEYS);
        this.addr = HAUtil.getJtHaRpcAddress(targetConf, jtId);
        this.autoFailoverEnabled = targetConf.getBoolean("mapred.ha.automatic-failover.enabled", false);
        if (this.autoFailoverEnabled && (port = MRZKFailoverController.getZkfcPort(targetConf)) != 0) {
            this.setZkfcPort(port);
        }
        try {
            this.fencer = NodeFencer.create((Configuration)targetConf, (String)"mapred.ha.fencing.methods");
        }
        catch (BadFencingConfigurationException e) {
            this.fenceConfigError = e;
        }
    }

    public void checkFencingConfigured() throws BadFencingConfigurationException {
        if (this.fenceConfigError != null) {
            throw this.fenceConfigError;
        }
        if (this.fencer == null) {
            throw new BadFencingConfigurationException("No fencer configured for " + (Object)((Object)this));
        }
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public NodeFencer getFencer() {
        return this.fencer;
    }

    public InetSocketAddress getZKFCAddress() {
        Preconditions.checkState((boolean)this.autoFailoverEnabled, (Object)"ZKFC address not relevant when auto failover is off");
        assert (this.zkfcAddr != null);
        return this.zkfcAddr;
    }

    public void setZkfcPort(int port) {
        assert (this.autoFailoverEnabled);
        this.zkfcAddr = new InetSocketAddress(this.addr.getAddress(), port);
    }

    public boolean isAutoFailoverEnabled() {
        return this.autoFailoverEnabled;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public String getJobTrackerId() {
        return this.jtId;
    }

    public String toString() {
        return "JobTrackerHAServiceTarget at " + this.addr;
    }
}

