/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.NetUtils2;
import org.apache.hadoop.net.NetUtils;

public class JobTrackerHAHttpRedirector {
    private static final Log LOG = LogFactory.getLog(JobTrackerHAHttpRedirector.class);
    static final String ACTIVE_JOBTRACKER_BASEURL = "mapred.ha.active.jobtracker.baseurl";
    private Configuration conf;
    private String activeJobTrackerUrl;
    private HttpServer server;

    public JobTrackerHAHttpRedirector(Configuration conf) {
        this.conf = conf;
        this.activeJobTrackerUrl = this.getActiveJobTrackerUrl(conf);
        if (this.activeJobTrackerUrl == null) {
            LOG.warn((Object)"No redirect address configured. Set mapred.ha.jobtracker.http-redirect-address");
        } else {
            LOG.info((Object)("Redirect address is " + this.activeJobTrackerUrl));
        }
    }

    private String getActiveJobTrackerUrl(Configuration conf) {
        StringBuilder sb = new StringBuilder(HttpConfig.getSchemePrefix());
        String otherJtId = HAUtil.getJobTrackerIdOfOtherNode(conf);
        sb.append(HAUtil.getJtHaHttpRedirectAddress(conf, otherJtId));
        return sb.toString();
    }

    public synchronized void start() throws Exception {
        if (this.activeJobTrackerUrl == null) {
            return;
        }
        if (this.server != null) {
            throw new Exception("JobTrackerHAHttpRedirector already running");
        }
        String infoAddr = NetUtils2.getServerAddress(this.conf, "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.job.tracker.http.address");
        LOG.info((Object)("Starting " + this.getClass().getSimpleName() + " on " + infoAddr));
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)infoAddr);
        String infoBindAddress = infoSocAddr.getHostName();
        int infoBindPort = infoSocAddr.getPort();
        this.server = new HttpServer("static", infoBindAddress, infoBindPort, false);
        this.server.addInternalServlet("redirector", "/*", RedirectorServlet.class, false);
        this.server.setAttribute(ACTIVE_JOBTRACKER_BASEURL, (Object)this.activeJobTrackerUrl);
        this.server.start();
        LOG.info((Object)"Started");
    }

    public synchronized void stop() throws Exception {
        if (this.server != null) {
            LOG.info((Object)("Stopping " + this.getClass().getSimpleName() + " on port " + this.server.getPort()));
            this.server.stop();
            this.server = null;
            LOG.info((Object)"Stopped");
        }
    }

    public static class RedirectorServlet
    extends HttpServlet {
        private String baseURL;
        private static final String REDIR_COUNT = "redirCount";

        public void init() {
            this.baseURL = (String)this.getServletContext().getAttribute(JobTrackerHAHttpRedirector.ACTIVE_JOBTRACKER_BASEURL);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            String redirCountStr = req.getParameter(REDIR_COUNT);
            int redirCount = (redirCountStr == null ? 0 : Integer.parseInt(redirCountStr)) + 1;
            if (redirCount == 1) {
                StringBuilder sb = new StringBuilder(this.baseURL);
                sb.append(req.getRequestURI());
                String queryString = req.getQueryString();
                if (queryString != null) {
                    sb.append("?").append(queryString);
                }
                sb.append(queryString == null ? "?" : "&").append(REDIR_COUNT).append("=").append(redirCount);
                resp.sendRedirect(sb.toString());
            } else {
                resp.sendError(503, "None of the JobTrackers is active");
            }
        }
    }
}

