/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerHAServiceProtocol;
import org.apache.hadoop.mapred.MapReducePolicyProvider;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;

public class JobTrackerHADaemon {
    private static final Log LOG;
    private Configuration conf;
    private JobTrackerRunner jtRunner;
    private JobTrackerHAServiceProtocol proto;
    private RPC.Server rpcServer;

    public JobTrackerHADaemon(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void start() throws IOException {
        Configuration jtConf = new Configuration(this.conf);
        String logicalName = HAUtil.getLogicalName(jtConf);
        String jtId = HAUtil.getJobTrackerId(jtConf);
        HAUtil.setGenericConf(jtConf, logicalName, jtId, HAUtil.JOB_TRACKER_SPECIFIC_KEYS);
        InetSocketAddress addr = HAUtil.getJtHaRpcAddress(this.conf, jtId);
        String localMachine = addr.getHostName();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"mapreduce.jobtracker.keytab.file", (String)"mapreduce.jobtracker.kerberos.principal", (String)localMachine);
        JobTracker.loggedIn = true;
        this.jtRunner = new JobTrackerRunner();
        this.jtRunner.start();
        this.proto = new JobTrackerHAServiceProtocol(jtConf, this.jtRunner);
        RPC.setProtocolEngine((Configuration)this.conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB((HAServiceProtocol)this.proto);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService((HAServiceProtocolProtos.HAServiceProtocolService.BlockingInterface)haServiceProtocolXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress rpcAddr = HAUtil.getJtHaRpcAddress(this.conf);
        this.rpcServer = RPC.getServer(HAServiceProtocolPB.class, (Object)haPbService, (String)rpcAddr.getHostName(), (int)rpcAddr.getPort(), (Configuration)this.conf);
        if (this.conf.getBoolean("hadoop.security.authorization", false)) {
            this.rpcServer.refreshServiceAcl(this.conf, (PolicyProvider)new MapReducePolicyProvider());
        }
        this.rpcServer.start();
        int port = this.rpcServer.getListenerAddress().getPort();
        HAUtil.setJtHaRpcAddress(this.conf, rpcAddr.getHostName() + ":" + port);
        LOG.info((Object)("Started " + this.getClass().getSimpleName() + " on port " + port));
    }

    public void makeActive() throws IOException {
        this.proto.transitionToActive(null);
    }

    public JobTracker getJobTracker() {
        return this.jtRunner.jt;
    }

    public JobTrackerHAServiceProtocol getJobTrackerHAServiceProtocol() {
        return this.proto;
    }

    public HAServiceStatus getServiceStatus() throws AccessControlException, IOException {
        return this.proto.getServiceStatus();
    }

    public void stop() throws IOException {
        this.proto.stop();
        this.rpcServer.stop();
    }

    public void join() {
        try {
            this.rpcServer.join();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static void startService() throws Exception {
        JobTrackerHADaemon daemon = new JobTrackerHADaemon(new Configuration());
        daemon.start();
        daemon.join();
    }

    public static void main(String[] args) {
        try {
            JobTrackerHADaemon.startService();
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    static {
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
        LOG = LogFactory.getLog(JobTrackerHADaemon.class);
    }

    public static class JobTrackerRunner
    extends Thread {
        private JobTracker jt;
        private JobConf conf;
        private volatile CountDownLatch startLatch;
        private volatile CountDownLatch startedLatch;
        private volatile boolean jtClosing;
        private Thread jtThread;

        public JobTrackerRunner() {
            super(JobTrackerRunner.class.getSimpleName());
            this.setDaemon(true);
            this.startLatch = new CountDownLatch(1);
            this.startedLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    this.startLatch.await();
                    this.jt = JobTracker.startTracker(this.conf);
                    this.jtThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JobTrackerRunner.this.jt.offerService();
                            }
                            catch (Throwable t) {
                                if (JobTrackerRunner.this.jtClosing) {
                                    LOG.info((Object)"Exception while closing jobtracker", t);
                                }
                                JobTrackerRunner.this.doImmediateShutdown(t);
                            }
                        }
                    }, JobTrackerRunner.class.getSimpleName() + "-JT");
                    this.jtThread.start();
                    this.waitForRunningState();
                    this.startedLatch.countDown();
                    this.jtThread.join();
                    continue;
                }
                catch (Throwable t) {
                    this.doImmediateShutdown(t);
                    continue;
                }
                finally {
                    this.startedLatch.countDown();
                    this.startLatch = new CountDownLatch(1);
                    this.startedLatch = new CountDownLatch(1);
                    continue;
                }
                break;
            }
        }

        private void waitForRunningState() {
            while (this.jt != null && this.jt.getClusterStatus(false).getJobTrackerStatus() != Cluster.JobTrackerStatus.RUNNING) {
                LOG.info((Object)"Waiting for jobtracker RUNNING state");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        private synchronized void doImmediateShutdown(Throwable t) throws ExitUtil.ExitException {
            String message = "Error encountered requiring JT shutdown. Shutting down immediately.";
            try {
                LOG.fatal((Object)message, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ExitUtil.terminate((int)1, (Throwable)t);
        }

        public void startJobTracker(JobConf conf) throws InterruptedException {
            if (this.jt == null) {
                this.conf = conf;
                this.startLatch.countDown();
                this.startedLatch.await();
            }
        }

        public void stopJobTracker() {
            try {
                if (this.jt != null) {
                    this.jtClosing = true;
                    this.jt.close();
                }
                if (this.jtThread != null) {
                    this.jtThread.join();
                }
            }
            catch (Throwable t) {
                this.doImmediateShutdown(t);
            }
            this.jt = null;
            this.jtClosing = false;
            this.jtThread = null;
        }

        public boolean jtThreadIsNotAlive() {
            return this.jtThread == null || !this.jtThread.isAlive();
        }

        @VisibleForTesting
        Thread getJobTrackerThread() {
            return this.jtThread;
        }
    }
}

