/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class HAUtil {
    private static final Log LOG = LogFactory.getLog(HAUtil.class);
    public static final String MR_JOBTRACKER_ADDRESS_KEY = "mapred.job.tracker";
    public static final String MR_JOBTRACKER_RPC_ADDRESS_KEY = "mapred.jobtracker.rpc-address";
    public static final String MR_JOBTRACKER_HTTP_ADDRESS_KEY = "mapred.job.tracker.http.address";
    public static final String MR_JOBTRACKER_OLD_HTTP_ADDRESS_KEY = "mapred.job.tracker.info.bindAddress";
    public static final String MR_JOBTRACKER_OLD_HTTP_PORT_KEY = "mapred.job.tracker.info.port";
    public static final String MR_HA_JOBTRACKERS_KEY_PREFIX = "mapred.jobtrackers";
    public static final String MR_HA_JOBTRACKER_RPC_ADDRESS_KEY = "mapred.ha.jobtracker.rpc-address";
    public static final String MR_HA_JOBTRACKER_HTTP_REDIRECT_ADDRESS_KEY = "mapred.ha.jobtracker.http-redirect-address";
    public static final String MR_HA_JOBTRACKER_ID_KEY = "mapred.ha.jobtracker.id";
    public static final String MR_HA_FENCING_METHODS_KEY = "mapred.ha.fencing.methods";
    public static final String MR_HA_AUTO_FAILOVER_ENABLED_KEY = "mapred.ha.automatic-failover.enabled";
    public static final boolean MR_HA_AUTO_FAILOVER_ENABLED_DEFAULT = false;
    public static final String MR_HA_ZKFC_PORT_KEY = "mapred.ha.zkfc.port";
    public static final int MR_HA_ZKFC_PORT_DEFAULT = 8018;
    public static final String MR_HA_ACTIVE_CHECK_MILLIS = "mapred.ha.jobtracker.active-check.millis";
    public static final int MR_HA_ACTIVE_CHECK_MILLIS_DEFAULT = 1000;
    public static final String MR_CLIENT_FAILOVER_PROXY_PROVIDER_KEY_PREFIX = "mapred.client.failover.proxy.provider";
    public static final String MR_CLIENT_FAILOVER_MAX_ATTEMPTS_KEY = "mapred.client.failover.max.attempts";
    public static final int MR_CLIENT_FAILOVER_MAX_ATTEMPTS_DEFAULT = 15;
    public static final String MR_CLIENT_FAILOVER_SLEEPTIME_BASE_KEY = "mapred.client.failover.sleep.base.millis";
    public static final int MR_CLIENT_FAILOVER_SLEEPTIME_BASE_DEFAULT = 500;
    public static final String MR_CLIENT_FAILOVER_SLEEPTIME_MAX_KEY = "mapred.client.failover.sleep.max.millis";
    public static final int MR_CLIENT_FAILOVER_SLEEPTIME_MAX_DEFAULT = 15000;
    public static final String MR_CLIENT_FAILOVER_CONNECTION_RETRIES_KEY = "mapred.client.failover.connection.retries";
    public static final int MR_CLIENT_FAILOVER_CONNECTION_RETRIES_DEFAULT = 0;
    public static final String MR_CLIENT_FAILOVER_CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_KEY = "mapred.client.failover.connection.retries.on.timeouts";
    public static final int MR_CLIENT_FAILOVER_CONNECTION_RETRIES_ON_SOCKET_TIMEOUTS_DEFAULT = 0;
    public static final String[] JOB_TRACKER_SPECIFIC_KEYS = new String[]{"mapred.jobtracker.rpc-address", "mapred.job.tracker.http.address", "mapred.job.tracker.info.bindAddress", "mapred.job.tracker.info.port", "mapred.ha.zkfc.port"};
    static final AddressMatcher LOCAL_ADDRESS_MATCHER = new AddressMatcher(){

        @Override
        public boolean match(InetSocketAddress s) {
            return NetUtils.isLocalAddress((InetAddress)s.getAddress());
        }
    };
    public static final String HA_DT_SERVICE_PREFIX = "ha-jt:";
    private static final DelegationTokenSelector tokenSelector = new DelegationTokenSelector();

    private HAUtil() {
    }

    public static boolean isHAEnabled() {
        Configuration conf = new Configuration();
        return HAUtil.isHAEnabled(conf, HAUtil.getLogicalName(conf));
    }

    public static boolean isHAEnabled(Configuration conf, String jtAddress) {
        Map<String, InetSocketAddress> jtMap = HAUtil.getHaJtRpcAddresses(conf);
        return jtMap != null && jtMap.size() > 1;
    }

    public static String getLogicalName(String jtAddress) {
        int index = jtAddress.indexOf(":");
        return index == -1 ? jtAddress : jtAddress.substring(0, index);
    }

    public static String getLogicalName(Configuration conf) {
        return HAUtil.getLogicalName(conf.get(MR_JOBTRACKER_ADDRESS_KEY));
    }

    public static String getJobTrackerId(Configuration conf) {
        String jtId = conf.get(MR_HA_JOBTRACKER_ID_KEY);
        if (jtId != null) {
            return jtId;
        }
        String logicalName = HAUtil.getLogicalName(conf);
        Collection<String> jtServiceIds = HAUtil.getJtServiceIds(conf, logicalName);
        if (jtServiceIds.size() == 1) {
            return jtServiceIds.toArray(new String[1])[0];
        }
        String[] suffixes = HAUtil.getSuffixIDs(conf, MR_JOBTRACKER_RPC_ADDRESS_KEY, logicalName, LOCAL_ADDRESS_MATCHER);
        if (suffixes == null) {
            String msg = "Configuration mapred.jobtracker.rpc-address must be suffixed with logicalName and jobtracker ID for HA configuration.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return suffixes[1];
    }

    public static String getJobTrackerIdOfOtherNode(Configuration conf) {
        String logicalName = HAUtil.getLogicalName(conf);
        Collection<String> jtServiceIds = HAUtil.getJtServiceIds(conf, logicalName);
        String myJtId = HAUtil.getJobTrackerId(conf);
        ArrayList jtSet = Lists.newArrayList(jtServiceIds);
        jtSet.remove(myJtId);
        assert (jtSet.size() == 1);
        return (String)jtSet.get(0);
    }

    static String[] getSuffixIDs(Configuration conf, String addressKey, String logicalName, AddressMatcher matcher) {
        String msg;
        String jobTrackerId = null;
        int found = 0;
        Collection<String> jtIds = HAUtil.getJtServiceIds(conf, logicalName);
        for (String jtId : HAUtil.emptyAsSingletonNull(jtIds)) {
            String key;
            String addr;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("addressKey: %s logicalName: %s jtId: %s", addressKey, logicalName, jtId));
            }
            if ((addr = conf.get(key = DFSUtil.addKeySuffixes((String)addressKey, (String[])new String[]{logicalName, jtId}))) == null) continue;
            InetSocketAddress s = null;
            try {
                s = NetUtils.createSocketAddr((String)addr);
            }
            catch (Exception e) {
                LOG.warn((Object)("Exception in creating socket address " + addr), (Throwable)e);
                continue;
            }
            if (s.isUnresolved() || !matcher.match(s)) continue;
            jobTrackerId = jtId;
            ++found;
        }
        if (found == 0) {
            msg = "Configuration has no addresses that match local node's address. Please configure the system with mapred.ha.jobtracker.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        if (found > 1) {
            msg = "Configuration has multiple addresses that match local node's address. Please configure the system with mapred.ha.jobtracker.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        return new String[]{logicalName, jobTrackerId};
    }

    private static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    public static Map<String, InetSocketAddress> getHaJtRpcAddresses(Configuration conf) {
        String logicalName = HAUtil.getLogicalName(conf);
        HashMap map = Maps.newHashMap();
        for (String jtId : HAUtil.getJtServiceIds(conf, logicalName)) {
            String address = conf.get(HAUtil.addKeySuffixes(MR_JOBTRACKER_RPC_ADDRESS_KEY, logicalName, jtId));
            InetSocketAddress isa = NetUtils.createSocketAddr((String)address);
            map.put(jtId, isa);
        }
        return map;
    }

    private static Collection<String> getJtServiceIds(Configuration conf, String logicalName) {
        return conf.getTrimmedStringCollection("mapred.jobtrackers." + logicalName);
    }

    private static String getKey(String prefix, Configuration conf) {
        String logicalName = HAUtil.getLogicalName(conf);
        String jtId = HAUtil.getJobTrackerId(conf);
        return HAUtil.addKeySuffixes(prefix, logicalName, jtId);
    }

    public static InetSocketAddress getJtHaRpcAddress(Configuration conf) {
        String address = conf.get(HAUtil.getKey(MR_HA_JOBTRACKER_RPC_ADDRESS_KEY, conf));
        return NetUtils.createSocketAddr((String)address);
    }

    public static void setJtHaRpcAddress(Configuration conf, String address) {
        conf.set(HAUtil.getKey(MR_HA_JOBTRACKER_RPC_ADDRESS_KEY, conf), address);
    }

    public static InetSocketAddress getJtHaRpcAddress(Configuration conf, String jtId) {
        String logicalName = HAUtil.getLogicalName(conf);
        String address = conf.get(HAUtil.addKeySuffixes(MR_HA_JOBTRACKER_RPC_ADDRESS_KEY, logicalName, jtId));
        return NetUtils.createSocketAddr((String)address);
    }

    public static void setJtRpcAddress(Configuration conf) {
        String rpcAddress = conf.get(HAUtil.getKey(MR_JOBTRACKER_RPC_ADDRESS_KEY, conf));
        conf.set(MR_JOBTRACKER_ADDRESS_KEY, rpcAddress);
    }

    public static String getJtHaHttpRedirectAddress(Configuration conf, String jtId) {
        String logicalName = HAUtil.getLogicalName(conf);
        return conf.get(HAUtil.addKeySuffixes(MR_HA_JOBTRACKER_HTTP_REDIRECT_ADDRESS_KEY, logicalName, jtId));
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        return DFSUtil.addKeySuffixes((String)key, (String[])suffixes);
    }

    public static void setGenericConf(Configuration conf, String logicalName, String jtId, String ... keys) {
        for (String key : keys) {
            String value = conf.get(HAUtil.addKeySuffixes(key, logicalName, jtId));
            if (value != null) {
                conf.set(key, value);
                continue;
            }
            value = conf.get(HAUtil.addKeySuffixes(key, logicalName));
            if (value == null) continue;
            conf.set(key, value);
        }
    }

    public static Text buildTokenServiceForLogicalAddress(String haJtAddress) {
        return new Text(HA_DT_SERVICE_PREFIX + haJtAddress);
    }

    public static boolean isTokenForLogicalAddress(Token<?> token) {
        return token.getService().toString().startsWith(HA_DT_SERVICE_PREFIX);
    }

    public static String getServiceAddressFromToken(Token<?> token) {
        String service = token.getService().toString();
        return HAUtil.isTokenForLogicalAddress(token) ? service.substring(HA_DT_SERVICE_PREFIX.length()) : service;
    }

    public static void cloneDelegationTokenForLogicalAddress(UserGroupInformation ugi, String haJtAddress, Collection<InetSocketAddress> jtAddresses) {
        Text haService = HAUtil.buildTokenServiceForLogicalAddress(haJtAddress);
        Token haToken = tokenSelector.selectToken(haService, ugi.getTokens());
        if (haToken != null) {
            for (InetSocketAddress singleJtAddr : jtAddresses) {
                Token specificToken = new Token(haToken);
                SecurityUtil.setTokenService((Token)specificToken, (InetSocketAddress)singleJtAddr);
                ugi.addToken(specificToken);
                LOG.debug((Object)("Mapped HA service delegation token for logical address " + haJtAddress + " to jt " + singleJtAddr));
            }
        } else {
            LOG.debug((Object)("No HA service delegation token found for logical address " + haJtAddress));
        }
    }

    private static interface AddressMatcher {
        public boolean match(InetSocketAddress var1);
    }
}

