/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.bundle;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifierFactory;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifierRegistry;
import org.semanticdesktop.aperture.mime.identifier.impl.MimeTypeIdentifierRegistryImpl;

public class MimeIdentifierServiceActivator
implements BundleActivator,
ServiceListener {
    private BundleContext bc = null;
    private ServiceRegistration registration;
    private MimeTypeIdentifierRegistry registry;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.registry = new MimeTypeIdentifierRegistryImpl();
        this.registration = this.bc.registerService(MimeTypeIdentifierRegistry.class.getName(), (Object)this.registry, new Hashtable());
        String filter = "(objectclass=" + MimeTypeIdentifierFactory.class.getName() + ")";
        this.bc.addServiceListener((ServiceListener)this, filter);
        ServiceReference[] references = this.bc.getServiceReferences(null, filter);
        for (int i = 0; references != null && i < references.length; ++i) {
            this.serviceChanged(new ServiceEvent(1, references[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc.removeServiceListener((ServiceListener)this);
        this.registration.unregister();
        this.bc = null;
    }

    public void serviceChanged(ServiceEvent event) {
        if (this.bc == null) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                MimeTypeIdentifierFactory factory = (MimeTypeIdentifierFactory)this.bc.getService(event.getServiceReference());
                this.registry.add(factory);
                break;
            }
            case 2: {
                MimeTypeIdentifierFactory factory = (MimeTypeIdentifierFactory)this.bc.getService(event.getServiceReference());
                this.registry.remove(factory);
                this.registry.add(factory);
                break;
            }
            case 4: {
                MimeTypeIdentifierFactory factory = (MimeTypeIdentifierFactory)this.bc.getService(event.getServiceReference());
                this.registry.remove(factory);
            }
        }
    }
}

