/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDCrossValidator {
    private final String languageCode;
    private final Dictionary abbreviations;
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private SentenceDetectorEvaluationMonitor[] listeners;

    public SDCrossValidator(String languageCode, TrainingParameters params, Dictionary abbreviations, SentenceDetectorEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = params;
        this.abbreviations = abbreviations;
        this.listeners = listeners;
    }

    public SDCrossValidator(String languageCode, int cutoff, int iterations) {
        this(languageCode, ModelUtil.createTrainingParameters(cutoff, iterations));
    }

    public SDCrossValidator(String languageCode, TrainingParameters params) {
        this(languageCode, params, (Dictionary)null, new SentenceDetectorEvaluationMonitor[0]);
    }

    @Deprecated
    public SDCrossValidator(String languageCode, int cutoff, int iterations, Dictionary abbreviations) {
        this(languageCode, ModelUtil.createTrainingParameters(cutoff, iterations), abbreviations, new SentenceDetectorEvaluationMonitor[0]);
    }

    public SDCrossValidator(String languageCode, TrainingParameters params, SentenceDetectorEvaluationMonitor ... listeners) {
        this(languageCode, params, (Dictionary)null, listeners);
    }

    public SDCrossValidator(String languageCode) {
        this(languageCode, 5, 100);
    }

    public void evaluate(ObjectStream<SentenceSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<SentenceSample> partitioner = new CrossValidationPartitioner<SentenceSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<SentenceSample> trainingSampleStream = partitioner.next();
            SentenceModel model = SentenceDetectorME.train(this.languageCode, trainingSampleStream, true, this.abbreviations, this.params);
            SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

