/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.mention.Parse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParse
implements Parse {
    @Override
    public boolean isCoordinatedNounPhrase() {
        List<Parse> parts = this.getSyntacticChildren();
        if (parts.size() >= 2) {
            for (int pi = 1; pi < parts.size(); ++pi) {
                Parse child = parts.get(pi);
                String ctype = child.getSyntacticType();
                if (ctype == null || !ctype.equals("CC") || ((Object)child).toString().equals("&")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Parse> getNounPhrases() {
        List<Parse> parts = this.getSyntacticChildren();
        ArrayList<Parse> nps = new ArrayList<Parse>();
        while (parts.size() > 0) {
            ArrayList<Parse> newParts = new ArrayList<Parse>();
            int pn = parts.size();
            for (int pi = 0; pi < pn; ++pi) {
                Parse cp = parts.get(pi);
                if (cp.isNounPhrase()) {
                    nps.add(cp);
                }
                if (cp.isToken()) continue;
                newParts.addAll(cp.getSyntacticChildren());
            }
            parts = newParts;
        }
        return nps;
    }
}

