/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

public final class SentenceDetectorEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "SentenceDetectorEvaluator";
    }

    public String getShortDescription() {
        return "evaluator for the learnable sentence detector";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(EvaluatorParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, EvaluatorParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        EvaluatorParams params = ArgumentParser.parse(args, EvaluatorParams.class);
        Charset encoding = params.getEncoding();
        SentenceModel model = (SentenceModel)new SentenceModelLoader().load(params.getModel());
        File trainingDataInFile = params.getData();
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        SentenceEvaluationErrorListener errorListener = null;
        if (params.getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(model), errorListener);
        System.out.print("Evaluating ... ");
        ObjectStream<SentenceSample> sampleStream = SentenceDetectorTrainerTool.openSampleData("Test", trainingDataInFile, encoding);
        try {
            evaluator.evaluate(sampleStream);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.err.println("done");
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }
}

