/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import opennlp.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.cmdline.chunker.ChunkerTrainerTool;
import opennlp.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.util.ObjectStream;

public final class ChunkerEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "ChunkerEvaluator";
    }

    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(EvalToolParams.class);
    }

    public void run(String[] args) {
        if (!ArgumentParser.validateArguments(args, EvaluatorParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        EvalToolParams params = ArgumentParser.parse(args, EvalToolParams.class);
        File testData = params.getData();
        CmdLineUtil.checkInputFile("Test data", testData);
        Charset encoding = params.getEncoding();
        ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(params.getModel());
        LinkedList<ChunkerEvaluationMonitor> listeners = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener detailedFMeasureListener = null;
        if (params.getMisclassified().booleanValue()) {
            listeners.add(new ChunkEvaluationErrorListener());
        }
        if (params.getDetailedF().booleanValue()) {
            detailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            listeners.add(detailedFMeasureListener);
        }
        ChunkerEvaluator evaluator = new ChunkerEvaluator(new ChunkerME(model, 10, new DefaultChunkerSequenceValidator()), listeners.toArray(new ChunkerEvaluationMonitor[listeners.size()]));
        final ObjectStream<ChunkSample> sampleStream = ChunkerTrainerTool.openSampleData("Test", testData, encoding);
        final PerformanceMonitor monitor = new PerformanceMonitor("sent");
        ObjectStream<ChunkSample> measuredSampleStream = new ObjectStream<ChunkSample>(){

            @Override
            public ChunkSample read() throws IOException {
                monitor.incrementCounter();
                return (ChunkSample)sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                sampleStream.close();
            }
        };
        monitor.startAndPrintThroughput();
        try {
            evaluator.evaluate(measuredSampleStream);
        }
        catch (IOException e) {
            System.err.println("failed");
            System.err.println("Reading test data error " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                measuredSampleStream.close();
            }
            catch (IOException e) {}
        }
        monitor.stopAndPrintFinalResult();
        System.out.println();
        if (detailedFMeasureListener == null) {
            System.out.println(evaluator.getFMeasure());
        } else {
            System.out.println(detailedFMeasureListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

