/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.video.tracking.klt.FeatureList;
import org.openimaj.video.tracking.klt.Pyramid;
import org.openimaj.video.tracking.klt.PyramidSet;
import org.openimaj.video.tracking.klt.TrackingContext;

public class KLTTracker {
    protected int KLT_verbose = 0;
    public static final int KLT_TRACKED = 0;
    public static final int KLT_NOT_FOUND = -1;
    public static final int KLT_SMALL_DET = -2;
    public static final int KLT_MAX_ITERATIONS = -3;
    public static final int KLT_OOB = -4;
    public static final int KLT_LARGE_RESIDUE = -5;
    TrackingContext tc;
    FeatureList featurelist;
    boolean isNorm = true;

    public KLTTracker(int nfeatures) {
        this.tc = new TrackingContext();
        this.featurelist = new FeatureList(nfeatures);
    }

    public KLTTracker(TrackingContext tc, FeatureList featurelist) {
        this.tc = tc;
        this.featurelist = featurelist;
    }

    private void _fillFeaturemap(int x, int y, BitSet featuremap, int mindist, int ncols, int nrows) {
        for (int iy = y - mindist; iy <= y + mindist; ++iy) {
            for (int ix = x - mindist; ix <= x + mindist; ++ix) {
                if (ix < 0 || ix >= ncols || iy < 0 || iy >= nrows) continue;
                featuremap.set(iy * ncols + ix);
            }
        }
    }

    private void _enforceMinimumDistance(int[][] pointlist, int ncols, int nrows, int mindist, int min_eigenvalue, boolean overwriteAllFeatures) {
        int y;
        int x;
        int indx;
        int npoints = pointlist.length;
        if (min_eigenvalue < 1) {
            min_eigenvalue = 1;
        }
        BitSet featuremap = new BitSet(ncols * nrows);
        --mindist;
        if (!overwriteAllFeatures) {
            for (indx = 0; indx < this.featurelist.features.length; ++indx) {
                if (this.featurelist.features[indx].val < 0) continue;
                x = (int)this.featurelist.features[indx].x;
                y = (int)this.featurelist.features[indx].y;
                this._fillFeaturemap(x, y, featuremap, mindist, ncols, nrows);
            }
        }
        int ptr = 0;
        indx = 0;
        while (true) {
            if (ptr >= npoints) {
                while (indx < this.featurelist.features.length) {
                    if (overwriteAllFeatures || this.featurelist.features[indx].val < 0) {
                        this.featurelist.features[indx].x = -1.0f;
                        this.featurelist.features[indx].y = -1.0f;
                        this.featurelist.features[indx].val = -1;
                    }
                    ++indx;
                }
                break;
            }
            x = pointlist[ptr][0];
            y = pointlist[ptr][1];
            int val = pointlist[ptr][2];
            ++ptr;
            assert (x >= 0);
            assert (x < ncols);
            assert (y >= 0);
            assert (y < nrows);
            while (!overwriteAllFeatures && indx < this.featurelist.features.length && this.featurelist.features[indx].val >= 0) {
                ++indx;
            }
            if (indx >= this.featurelist.features.length) break;
            if (featuremap.get(y * ncols + x) || val < min_eigenvalue) continue;
            this.featurelist.features[indx].x = x;
            this.featurelist.features[indx].y = y;
            this.featurelist.features[indx].val = val;
            ++indx;
            this._fillFeaturemap(x, y, featuremap, mindist, ncols, nrows);
        }
    }

    private void _sortPointList(int[][] pointlist) {
        Arrays.sort(pointlist, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int v1 = o1[2];
                int v2 = o2[2];
                if (v1 > v2) {
                    return -1;
                }
                if (v1 < v2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private float _minEigenvalue(float gxx, float gxy, float gyy) {
        return (float)(((double)(gxx + gyy) - Math.sqrt((gxx - gyy) * (gxx - gyy) + 4.0f * gxy * gxy)) / 2.0);
    }

    private void _selectGoodFeatures(FImage img, SelectionMode mode) {
        FImage grady;
        FImage gradx;
        FImage floatimg;
        boolean overwriteAllFeatures;
        int nrows = img.height;
        int ncols = img.width;
        boolean bl = overwriteAllFeatures = mode == SelectionMode.SELECTING_ALL;
        if (this.tc.window_width % 2 != 1) {
            ++this.tc.window_width;
            System.err.format("Tracking context's window width must be odd.  Changing to %d.\n", this.tc.window_width);
        }
        if (this.tc.window_height % 2 != 1) {
            ++this.tc.window_height;
            System.err.format("Tracking context's window height must be odd.  Changing to %d.\n", this.tc.window_height);
        }
        if (this.tc.window_width < 3) {
            this.tc.window_width = 3;
            System.err.format("Tracking context's window width must be at least three.  \nChanging to %d.\n", this.tc.window_width);
        }
        if (this.tc.window_height < 3) {
            this.tc.window_height = 3;
            System.err.format("Tracking context's window height must be at least three.  \nChanging to %d.\n", this.tc.window_height);
        }
        int window_hw = this.tc.window_width / 2;
        int window_hh = this.tc.window_height / 2;
        int[][] pointlist = new int[ncols * nrows][3];
        PyramidSet ppSet = this.tc.previousPyramidSet();
        if (mode == SelectionMode.REPLACING_SOME && this.tc.sequentialMode && ppSet != null) {
            floatimg = ppSet.imgPyr.img[0];
            gradx = ppSet.gradx.img[0];
            grady = ppSet.grady.img[0];
            assert (gradx != null);
            assert (grady != null);
        } else {
            floatimg = new FImage(ncols, nrows);
            gradx = new FImage(ncols, nrows);
            grady = new FImage(ncols, nrows);
            floatimg = this.tc.smoothBeforeSelecting ? (FImage)img.process((SinglebandImageProcessor)new FGaussianConvolve(this.tc.computeSmoothSigma())) : img.clone();
            this.tc.computeGradients(floatimg, this.tc.grad_sigma, gradx, grady);
        }
        if (this.tc.writeInternalImages) {
            try {
                ImageUtilities.write((Image)floatimg, (String)"png", (File)new File("kltimg_sgfrlf.png"));
                ImageUtilities.write((Image)gradx, (String)"png", (File)new File("kltimg_sgfrlf_gx.png"));
                ImageUtilities.write((Image)grady, (String)"png", (File)new File("kltimg_sgfrlf_gy.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int limit = 1;
        int borderx = this.tc.borderx;
        int bordery = this.tc.bordery;
        if (borderx < window_hw) {
            borderx = window_hw;
        }
        if (bordery < window_hh) {
            bordery = window_hh;
        }
        limit = 0x3FFFFFFE;
        int ptr = 0;
        for (int y = bordery; y < nrows - bordery; y += this.tc.nSkippedPixels + 1) {
            for (int x = borderx; x < ncols - borderx; x += this.tc.nSkippedPixels + 1) {
                if (this.tc.getTargetArea() != null) {
                    Point2dImpl point = new Point2dImpl((float)x, (float)y);
                    if (!this.tc.getTargetArea().isInside((Point2d)point)) continue;
                }
                float gxx = 0.0f;
                float gxy = 0.0f;
                float gyy = 0.0f;
                for (int yy = y - window_hh; yy <= y + window_hh; ++yy) {
                    for (int xx = x - window_hw; xx <= x + window_hw; ++xx) {
                        float gx = gradx.pixels[yy][xx];
                        float gy = grady.pixels[yy][xx];
                        gxx += gx * gx;
                        gxy += gx * gy;
                        gyy += gy * gy;
                    }
                }
                pointlist[ptr][0] = x;
                pointlist[ptr][1] = y;
                float val = this._minEigenvalue(gxx, gxy, gyy);
                if (val > (float)limit) {
                    System.err.format("(_KLTSelectGoodFeatures) minimum eigenvalue %f is greater than the capacity of an int; setting to maximum value", Float.valueOf(val));
                    val = limit;
                }
                pointlist[ptr][2] = (int)val;
                ++ptr;
            }
        }
        this._sortPointList(pointlist);
        if (this.tc.mindist < 0) {
            System.err.format("(_KLTSelectGoodFeatures) Tracking context field tc.mindist is negative (%d); setting to zero", this.tc.mindist);
            this.tc.mindist = 0;
        }
        this._enforceMinimumDistance(pointlist, ncols, nrows, this.tc.mindist, this.tc.min_eigenvalue, overwriteAllFeatures);
    }

    public void selectGoodFeatures(FImage img) {
        if (this.isNorm) {
            img = img.multiply(Float.valueOf(255.0f));
        }
        if (this.KLT_verbose >= 1) {
            System.err.format("(KLT) Selecting the %d best features from a %d by %d image...  ", this.featurelist.features.length, img.width, img.height);
        }
        this._selectGoodFeatures(img, SelectionMode.SELECTING_ALL);
        if (this.KLT_verbose >= 1) {
            System.err.format("\n\t%d features found.\n", this.featurelist.countRemainingFeatures());
            if (this.tc.writeInternalImages) {
                System.err.format("\tWrote images to 'kltimg_sgfrlf*.pgm'.\n", new Object[0]);
            }
        }
    }

    public void replaceLostFeatures(FImage img) {
        if (this.isNorm) {
            img = img.multiply(Float.valueOf(255.0f));
        }
        int nLostFeatures = this.featurelist.features.length - this.featurelist.countRemainingFeatures();
        if (this.KLT_verbose >= 1) {
            System.err.format("(KLT) Attempting to replace %d features in a %d by %d image...  ", nLostFeatures, img.width, img.height);
        }
        if (nLostFeatures > 0) {
            this._selectGoodFeatures(img, SelectionMode.REPLACING_SOME);
        }
        if (this.KLT_verbose >= 1) {
            System.err.format("\n\t%d features replaced.\n", nLostFeatures - this.featurelist.features.length + this.featurelist.countRemainingFeatures());
            if (this.tc.writeInternalImages) {
                System.err.format("\tWrote images to 'kltimg_sgfrlf*.pgm'.\n", new Object[0]);
            }
        }
    }

    public void setVerbosity(int verbosity) {
        this.KLT_verbose = verbosity;
    }

    private float _interpolate(float x, float y, FImage img) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        float x0y0 = img.pixels[yt][xt];
        float x1y0 = img.pixels[yt][xt + 1];
        float x0y1 = img.pixels[yt + 1][xt];
        float x1y1 = img.pixels[yt + 1][xt + 1];
        return (1.0f - ax) * (1.0f - ay) * x0y0 + ax * (1.0f - ay) * x1y0 + (1.0f - ax) * ay * x0y1 + ax * ay * x1y1;
    }

    private void _computeIntensityDifference(FImage img1, FImage img2, float x1, float y1, float x2, float y2, int width, int height, float[] imgdiff) {
        int hw = width / 2;
        int hh = height / 2;
        int idx = 0;
        for (int j = -hh; j <= hh; ++j) {
            for (int i = -hw; i <= hw; ++i) {
                float g1 = this._interpolate(x1 + (float)i, y1 + (float)j, img1);
                float g2 = this._interpolate(x2 + (float)i, y2 + (float)j, img2);
                imgdiff[idx++] = g1 - g2;
            }
        }
    }

    private void _computeGradientSum(FImage gradx1, FImage grady1, FImage gradx2, FImage grady2, float x1, float y1, float x2, float y2, int width, int height, float[] gradx, float[] grady) {
        int hw = width / 2;
        int hh = height / 2;
        int gx = 0;
        int gy = 0;
        for (int j = -hh; j <= hh; ++j) {
            for (int i = -hw; i <= hw; ++i) {
                float g1 = this._interpolate(x1 + (float)i, y1 + (float)j, gradx1);
                float g2 = this._interpolate(x2 + (float)i, y2 + (float)j, gradx2);
                gradx[gx++] = g1 + g2;
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, grady1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, grady2);
                grady[gy++] = g1 + g2;
            }
        }
    }

    private void _computeIntensityDifferenceLightingInsensitive(FImage img1, FImage img2, float x1, float y1, float x2, float y2, int width, int height, float[] imgdiff) {
        float g2;
        float g1;
        int i;
        int j;
        int hw = width / 2;
        int hh = height / 2;
        float sum1_squared = 0.0f;
        float sum2_squared = 0.0f;
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        for (j = -hh; j <= hh; ++j) {
            for (i = -hw; i <= hw; ++i) {
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, img1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, img2);
                sum1 += g1;
                sum2 += g2;
                sum1_squared += g1 * g1;
                sum2_squared += g2 * g2;
            }
        }
        float mean1 = sum1_squared / (float)(width * height);
        float mean2 = sum2_squared / (float)(width * height);
        float alpha = (float)Math.sqrt(mean1 / mean2);
        mean1 = sum1 / (float)(width * height);
        mean2 = sum2 / (float)(width * height);
        float belta = mean1 - alpha * mean2;
        int id = 0;
        for (j = -hh; j <= hh; ++j) {
            for (i = -hw; i <= hw; ++i) {
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, img1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, img2);
                imgdiff[id++] = g1 - g2 * alpha - belta;
            }
        }
    }

    private void _computeGradientSumLightingInsensitive(FImage gradx1, FImage grady1, FImage gradx2, FImage grady2, FImage img1, FImage img2, float x1, float y1, float x2, float y2, int width, int height, float[] gradx, float[] grady) {
        float g2;
        float g1;
        int i;
        int j;
        int hw = width / 2;
        int hh = height / 2;
        float sum1_squared = 0.0f;
        float sum2_squared = 0.0f;
        for (j = -hh; j <= hh; ++j) {
            for (i = -hw; i <= hw; ++i) {
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, img1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, img2);
                sum1_squared += g1;
                sum2_squared += g2;
            }
        }
        float mean1 = sum1_squared / (float)(width * height);
        float mean2 = sum2_squared / (float)(width * height);
        float alpha = (float)Math.sqrt(mean1 / mean2);
        int gx = 0;
        int gy = 0;
        for (j = -hh; j <= hh; ++j) {
            for (i = -hw; i <= hw; ++i) {
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, gradx1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, gradx2);
                gradx[gx++] = g1 + g2 * alpha;
                g1 = this._interpolate(x1 + (float)i, y1 + (float)j, grady1);
                g2 = this._interpolate(x2 + (float)i, y2 + (float)j, grady2);
                grady[gy++] = g1 + g2 * alpha;
            }
        }
    }

    private float[] _compute2by2GradientMatrix(float[] gradx, float[] grady, int width, int height) {
        float gxx = 0.0f;
        float gxy = 0.0f;
        float gyy = 0.0f;
        for (int i = 0; i < width * height; ++i) {
            float gx = gradx[i];
            float gy = grady[i];
            gxx += gx * gx;
            gxy += gx * gy;
            gyy += gy * gy;
        }
        return new float[]{gxx, gxy, gyy};
    }

    private float[] _compute2by1ErrorVector(float[] imgdiff, float[] gradx, float[] grady, int width, int height, float step_factor) {
        float ex = 0.0f;
        float ey = 0.0f;
        for (int i = 0; i < width * height; ++i) {
            float diff = imgdiff[i];
            ex += diff * gradx[i];
            ey += diff * grady[i];
        }
        return new float[]{ex *= step_factor, ey *= step_factor};
    }

    private int _solveEquation(float gxx, float gxy, float gyy, float ex, float ey, float small, float[] output) {
        float det = gxx * gyy - gxy * gxy;
        if (det < small) {
            return -2;
        }
        output[0] = (gyy * ex - gxy * ey) / det;
        output[1] = (gxx * ey - gxy * ex) / det;
        return 0;
    }

    private float _sumAbsFloatWindow(float[] fw, int width, int height) {
        float sum = 0.0f;
        for (int i = 0; i < height * width; ++i) {
            sum += Math.abs(fw[i]);
        }
        return sum;
    }

    private int _trackFeature(float x1, float y1, float[] xy2, FImage img1, FImage gradx1, FImage grady1, FImage img2, FImage gradx2, FImage grady2, int width, int height, float step_factor, int max_iterations, float small, float th, float max_residue, boolean lighting_insensitive) {
        int status;
        float dy;
        float dx;
        int iteration = 0;
        int hw = width / 2;
        int hh = height / 2;
        int nc = img1.width;
        int nr = img1.height;
        float one_plus_eps = 1.001f;
        float[] imgdiff = new float[height * width];
        float[] gradx = new float[height * width];
        float[] grady = new float[height * width];
        do {
            if (x1 - (float)hw < 0.0f || (float)nc - (x1 + (float)hw) < 1.001f || xy2[0] - (float)hw < 0.0f || (float)nc - (xy2[0] + (float)hw) < 1.001f || y1 - (float)hh < 0.0f || (float)nr - (y1 + (float)hh) < 1.001f || xy2[1] - (float)hh < 0.0f || (float)nr - (xy2[1] + (float)hh) < 1.001f) {
                status = -4;
                break;
            }
            if (lighting_insensitive) {
                this._computeIntensityDifferenceLightingInsensitive(img1, img2, x1, y1, xy2[0], xy2[1], width, height, imgdiff);
                this._computeGradientSumLightingInsensitive(gradx1, grady1, gradx2, grady2, img1, img2, x1, y1, xy2[0], xy2[1], width, height, gradx, grady);
            } else {
                this._computeIntensityDifference(img1, img2, x1, y1, xy2[0], xy2[1], width, height, imgdiff);
                this._computeGradientSum(gradx1, grady1, gradx2, grady2, x1, y1, xy2[0], xy2[1], width, height, gradx, grady);
            }
            float[] tmp = this._compute2by2GradientMatrix(gradx, grady, width, height);
            float gxx = tmp[0];
            float gxy = tmp[1];
            float gyy = tmp[2];
            tmp = this._compute2by1ErrorVector(imgdiff, gradx, grady, width, height, step_factor);
            float ex = tmp[0];
            float ey = tmp[1];
            tmp = new float[2];
            status = this._solveEquation(gxx, gxy, gyy, ex, ey, small, tmp);
            dx = tmp[0];
            dy = tmp[1];
            if (status == -2) break;
            xy2[0] = xy2[0] + dx;
            xy2[1] = xy2[1] + dy;
        } while ((Math.abs(dx) >= th || Math.abs(dy) >= th) && ++iteration < max_iterations);
        if (xy2[0] - (float)hw < 0.0f || (float)nc - (xy2[0] + (float)hw) < 1.001f || xy2[1] - (float)hh < 0.0f || (float)nr - (xy2[1] + (float)hh) < 1.001f) {
            status = -4;
        }
        if (status == 0) {
            if (lighting_insensitive) {
                this._computeIntensityDifferenceLightingInsensitive(img1, img2, x1, y1, xy2[0], xy2[1], width, height, imgdiff);
            } else {
                this._computeIntensityDifference(img1, img2, x1, y1, xy2[0], xy2[1], width, height, imgdiff);
            }
            if (this._sumAbsFloatWindow(imgdiff, width, height) / (float)(width * height) > max_residue) {
                status = -5;
            }
        }
        if (status == -2) {
            return -2;
        }
        if (status == -4) {
            return -4;
        }
        if (status == -5) {
            return -5;
        }
        if (iteration >= max_iterations) {
            return -3;
        }
        return 0;
    }

    private boolean _outOfBounds(float x, float y, int ncols, int nrows, int borderx, int bordery) {
        return x < (float)borderx || x > (float)(ncols - 1 - borderx) || y < (float)bordery || y > (float)(nrows - 1 - bordery);
    }

    public void trackFeatures(FImage img1, FImage img2) {
        PyramidSet pyr1;
        if (this.isNorm) {
            img1 = img1.multiply(Float.valueOf(255.0f));
            img2 = img2.multiply(Float.valueOf(255.0f));
        }
        int nrows = img1.height;
        int ncols = img1.width;
        if (this.KLT_verbose >= 1) {
            System.out.println(String.format("(KLT) Tracking %d features in a %d by %d image...  ", this.featurelist.countRemainingFeatures(), ncols, nrows));
        }
        if (this.tc.window_width % 2 != 1) {
            ++this.tc.window_width;
            System.out.println(String.format("Tracking context's window width must be odd.  Changing to %d.\n", this.tc.window_width));
        }
        if (this.tc.window_height % 2 != 1) {
            ++this.tc.window_height;
            System.out.println(String.format("Tracking context's window height must be odd.  Changing to %d.\n", this.tc.window_height));
        }
        if (this.tc.window_width < 3) {
            this.tc.window_width = 3;
            System.out.println(String.format("Tracking context's window width must be at least three.  \nChanging to %d.\n", this.tc.window_width));
        }
        if (this.tc.window_height < 3) {
            this.tc.window_height = 3;
            System.out.println(String.format("Tracking context's window height must be at least three.  \nChanging to %d.\n", this.tc.window_height));
        }
        PyramidSet ppSet = this.tc.previousPyramidSet();
        if (this.tc.sequentialMode && ppSet != null) {
            Pyramid pyramid1 = ppSet.imgPyr;
            Pyramid pyramid1_gradx = ppSet.gradx;
            Pyramid pyramid1_grady = ppSet.grady;
            if (pyramid1.ncols[0] != ncols || pyramid1.nrows[0] != nrows) {
                throw new RuntimeException(String.format("(KLTTrackFeatures) Size of incoming image (%d by %d) is different from size of previous image (%d by %d)\n", ncols, nrows, pyramid1.ncols[0], pyramid1.nrows[0]));
            }
            assert (pyramid1_gradx != null);
            assert (pyramid1_grady != null);
            pyr1 = ppSet;
        } else {
            pyr1 = new PyramidSet(img1, this.tc);
        }
        PyramidSet pyr2 = new PyramidSet(img2, this.tc);
        if (this.tc.writeInternalImages) {
            for (int i = 0; i < this.tc.nPyramidLevels; ++i) {
                try {
                    String fname = String.format("kltimg_tf_i%d.png", i);
                    ImageUtilities.write((Image)pyr1.imgPyr.img[i], (String)"png", (File)new File(fname));
                    fname = String.format("kltimg_tf_i%d_gx.png", i);
                    ImageUtilities.write((Image)pyr1.gradx.img[i], (String)"png", (File)new File(fname));
                    fname = String.format("kltimg_tf_i%d_gy.png", i);
                    ImageUtilities.write((Image)pyr1.grady.img[i], (String)"png", (File)new File(fname));
                    fname = String.format("kltimg_tf_j%d.png", i);
                    ImageUtilities.write((Image)pyr2.imgPyr.img[i], (String)"png", (File)new File(fname));
                    fname = String.format("kltimg_tf_j%d_gx.png", i);
                    ImageUtilities.write((Image)pyr2.gradx.img[i], (String)"png", (File)new File(fname));
                    fname = String.format("kltimg_tf_j%d_gy.png", i);
                    ImageUtilities.write((Image)pyr2.grady.img[i], (String)"png", (File)new File(fname));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.trackFeatures(img1, img2, pyr1, pyr2);
        if (this.tc.sequentialMode) {
            this.tc.setPreviousPyramid(pyr2);
        }
        if (this.KLT_verbose >= 1) {
            System.err.println(String.format("\n\t%d features successfully tracked.\n", this.featurelist.countRemainingFeatures()));
            if (this.tc.writeInternalImages) {
                System.err.println("\tWrote images to 'kltimg_tf*.pgm'.\n");
            }
        }
    }

    public void trackFeatures(FImage img1, FImage img2, PyramidSet pyr1, PyramidSet pyr2) {
        int val = -1;
        float subsampling = this.tc.subsampling;
        int nrows = img1.height;
        int ncols = img1.width;
        for (int indx = 0; indx < this.featurelist.features.length; ++indx) {
            int r;
            if (this.featurelist.features[indx].val < 0) continue;
            float xloc = this.featurelist.features[indx].x;
            float yloc = this.featurelist.features[indx].y;
            for (r = this.tc.nPyramidLevels - 1; r >= 0; --r) {
                xloc /= subsampling;
                yloc /= subsampling;
            }
            float xlocout = xloc;
            float ylocout = yloc;
            for (r = this.tc.nPyramidLevels - 1; r >= 0; --r) {
                float[] xylocout = new float[]{xlocout *= subsampling, ylocout *= subsampling};
                val = this._trackFeature(xloc *= subsampling, yloc *= subsampling, xylocout, pyr1.imgPyr.img[r], pyr1.gradx.img[r], pyr1.grady.img[r], pyr2.imgPyr.img[r], pyr2.gradx.img[r], pyr2.grady.img[r], this.tc.window_width, this.tc.window_height, this.tc.step_factor, this.tc.max_iterations, this.tc.min_determinant, this.tc.min_displacement, this.tc.max_residue, this.tc.lighting_insensitive);
                xlocout = xylocout[0];
                ylocout = xylocout[1];
                if (val == -2 || val == -4) break;
            }
            if (val == -4) {
                this.featurelist.features[indx].x = -1.0f;
                this.featurelist.features[indx].y = -1.0f;
                this.featurelist.features[indx].val = -4;
                continue;
            }
            if (this._outOfBounds(xlocout, ylocout, ncols, nrows, this.tc.borderx, this.tc.bordery)) {
                this.featurelist.features[indx].x = -1.0f;
                this.featurelist.features[indx].y = -1.0f;
                this.featurelist.features[indx].val = -4;
                continue;
            }
            if (val == -2) {
                this.featurelist.features[indx].x = -1.0f;
                this.featurelist.features[indx].y = -1.0f;
                this.featurelist.features[indx].val = -2;
                continue;
            }
            if (val == -5) {
                this.featurelist.features[indx].x = -1.0f;
                this.featurelist.features[indx].y = -1.0f;
                this.featurelist.features[indx].val = -5;
                continue;
            }
            if (val == -3) {
                this.featurelist.features[indx].x = -1.0f;
                this.featurelist.features[indx].y = -1.0f;
                this.featurelist.features[indx].val = -3;
                continue;
            }
            this.featurelist.features[indx].x = xlocout;
            this.featurelist.features[indx].y = ylocout;
            this.featurelist.features[indx].val = 0;
            if (this.tc.affineConsistencyCheck < 0 || val != 0) continue;
            throw new UnsupportedOperationException("Affine mapping not yet implemented");
        }
    }

    public TrackingContext getTrackingContext() {
        return this.tc;
    }

    public void setTrackingContext(TrackingContext tc) {
        this.tc = tc;
    }

    public FeatureList getFeatureList() {
        return this.featurelist;
    }

    public void setFeatureList(FeatureList featurelist) {
        this.featurelist = featurelist;
    }

    public boolean isNorm() {
        return this.isNorm;
    }

    public void setNorm(boolean isNorm) {
        this.isNorm = isNorm;
    }

    public static enum SelectionMode {
        SELECTING_ALL,
        REPLACING_SOME;

    }
}

