/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openimaj.video.tracking.klt.Feature;
import org.openimaj.video.tracking.klt.FeatureList;
import org.openimaj.video.tracking.klt.IOUtils;

public class FeatureTable {
    public SortedMap<Integer, List<Feature>> features = new TreeMap<Integer, List<Feature>>();
    public int nFeatures;

    public FeatureTable(int nFeatures) {
        this.nFeatures = nFeatures;
    }

    public void storeFeatureList(FeatureList fl, int frame) {
        ArrayList<Feature> list = new ArrayList<Feature>(fl.features.length);
        for (Feature f : fl.features) {
            list.add(f.clone());
        }
        this.features.put(frame, list);
    }

    public String toString(String fmt, boolean comments) {
        String[] setup = IOUtils.setupTxtFormat(fmt);
        String format = setup[0];
        String type = setup[1];
        String s = IOUtils.getHeader(format, IOUtils.StructureType.FEATURE_TABLE, this.features.size(), this.nFeatures, comments);
        for (int j = 0; j < this.nFeatures; ++j) {
            s = s + String.format("%7d | ", j);
            for (int i = 0; i < this.features.size(); ++i) {
                s = s + ((Feature)((List)this.features.get(i)).get(j)).toString(format, type);
            }
            s = s + "\n";
        }
        return s;
    }

    public String toString() {
        return this.toString("%3d", false);
    }

    public void writeFeatureTable(File fname, String fmt) throws IOException {
        if (fmt != null) {
            if (fname != null) {
                PrintWriter bw = new PrintWriter(new FileOutputStream(fname));
                bw.write(this.toString(fmt, true));
                bw.close();
            } else {
                System.out.print(this.toString(fmt, false));
            }
        } else {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(fname));
            dos.write(IOUtils.binheader_ft.getBytes("US-ASCII"));
            dos.writeInt(this.features.size());
            dos.writeInt(this.nFeatures);
            for (int j = 0; j < this.nFeatures; ++j) {
                for (int i = 0; i < this.features.size(); ++i) {
                    ((Feature)((List)this.features.get(j)).get(i)).writeFeatureBin(dos);
                }
            }
            dos.close();
        }
    }
}

