/*
 * Decompiled with CFR 0.152.
 */
package org.jbibtex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXInclude;
import org.jbibtex.BibTeXObject;
import org.jbibtex.BibTeXString;
import org.jbibtex.Key;
import org.jbibtex.KeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BibTeXDatabase {
    private List<BibTeXObject> objects = new ArrayList<BibTeXObject>();
    private List<BibTeXInclude> includes = new ArrayList<BibTeXInclude>();
    private KeyMap<BibTeXString> strings = new KeyMap();
    private KeyMap<BibTeXEntry> entries = new KeyMap();

    public void addObject(BibTeXObject object) {
        this.objects.add(object);
        if (object instanceof BibTeXInclude) {
            BibTeXInclude include = (BibTeXInclude)object;
            this.includes.add(include);
        } else if (object instanceof BibTeXString) {
            BibTeXString string = (BibTeXString)object;
            this.strings.put(string.getKey(), string);
        } else if (object instanceof BibTeXEntry) {
            BibTeXEntry entry = (BibTeXEntry)object;
            this.entries.put(entry.getKey(), entry);
        }
    }

    public void removeObject(BibTeXObject object) {
        this.objects.remove(object);
        if (object instanceof BibTeXInclude) {
            BibTeXInclude include = (BibTeXInclude)object;
            this.includes.remove(include);
        } else if (object instanceof BibTeXString) {
            BibTeXString string = (BibTeXString)object;
            this.strings.remove(string.getKey());
        } else if (object instanceof BibTeXEntry) {
            BibTeXEntry entry = (BibTeXEntry)object;
            this.entries.remove(entry.getKey());
        }
    }

    public List<BibTeXObject> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }

    public BibTeXString resolveString(Key key) {
        BibTeXString string = (BibTeXString)this.strings.get(key);
        if (string == null) {
            for (BibTeXInclude include : this.includes) {
                BibTeXDatabase database = include.getDatabase();
                string = database.resolveString(key);
                if (string == null) continue;
                return string;
            }
        }
        return string;
    }

    public Map<Key, BibTeXString> getStrings() {
        return Collections.unmodifiableMap(this.strings);
    }

    public BibTeXEntry resolveEntry(Key key) {
        BibTeXEntry entry = (BibTeXEntry)this.entries.get(key);
        if (entry == null) {
            for (BibTeXInclude include : this.includes) {
                BibTeXDatabase database = include.getDatabase();
                entry = database.resolveEntry(key);
                if (entry == null) continue;
                return entry;
            }
        }
        return entry;
    }

    public Map<Key, BibTeXEntry> getEntries() {
        return Collections.unmodifiableMap(this.entries);
    }
}

