/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.samples;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.ph.snuggletex.InputError;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptionsTemplates;
import uk.ac.ed.ph.snuggletex.internal.util.IOUtilities;
import uk.ac.ed.ph.snuggletex.utilities.MessageFormatter;

public class CommandLineRunner {
    private final String[] args;
    private final List<String> inputFiles;
    private WebPageOutputOptions snuggleOptions;
    private boolean requestedWebOutput;

    public CommandLineRunner(String[] args) {
        this.args = args;
        this.inputFiles = new ArrayList<String>();
        this.snuggleOptions = null;
        this.requestedWebOutput = false;
    }

    public void execute() {
        if (this.args.length == 0) {
            this.showHelp();
            return;
        }
        try {
            if (!this.parseCommandLineArguments()) {
                this.showUsage();
                return;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            this.showHelp();
            return;
        }
        if (this.inputFiles.isEmpty()) {
            System.err.println("No input files specified");
            this.showHelp();
            return;
        }
        SnuggleEngine engine = new SnuggleEngine();
        SnuggleSession session = engine.createSession();
        try {
            for (String inputFile : this.inputFiles) {
                SnuggleInput input = inputFile.equals("-") ? new SnuggleInput(System.in) : new SnuggleInput(new File(inputFile));
                session.parseInput(input);
            }
            if (this.requestedWebOutput) {
                session.writeWebPage(this.snuggleOptions, System.out, SnuggleSession.EndOutputAction.FLUSH);
            } else {
                System.out.println(session.buildXMLString(this.snuggleOptions));
            }
            if (!this.snuggleOptions.isIndenting()) {
                System.out.println();
            }
        }
        catch (IOException e) {
            System.err.println("Got IOException running SnuggleTeX: " + e.getMessage());
        }
        for (InputError error : session.getErrors()) {
            System.err.println(MessageFormatter.formatErrorAsString(error));
        }
    }

    private void showHelp() {
        System.out.println("For help and usage, use the -? option");
    }

    private void showUsage() {
        InputStream usageStream = this.getClass().getClassLoader().getResourceAsStream("uk/ac/ed/ph/snuggletex/command-line-usage.txt");
        try {
            IOUtilities.transfer(usageStream, System.out);
        }
        catch (IOException e) {
            throw new SnuggleRuntimeException("Unexpected Exception printing out usage info", e);
        }
    }

    private boolean parseCommandLineArguments() {
        String nextArg;
        String arg;
        WebPageOutputOptions.WebPageType webPageType = null;
        int i = 0;
        while (i < this.args.length) {
            arg = this.args[i];
            String string = nextArg = i < this.args.length - 1 ? this.args[i + 1] : null;
            if ("-web".equals(arg)) {
                String webPageTypeName = nextArg;
                if (webPageTypeName == null) {
                    throw new IllegalArgumentException("No value provided for -web option");
                }
                try {
                    webPageType = WebPageOutputOptions.WebPageType.valueOf(webPageTypeName);
                    this.requestedWebOutput = true;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Unknown web page type " + webPageTypeName);
                }
                ++i;
            }
            ++i;
        }
        this.snuggleOptions = this.requestedWebOutput ? WebPageOutputOptionsTemplates.createWebPageOptions(webPageType) : new WebPageOutputOptions();
        i = 0;
        while (i < this.args.length) {
            arg = this.args[i];
            String string = nextArg = i < this.args.length - 1 ? this.args[i + 1] : null;
            if ("-".equals(arg)) {
                this.inputFiles.add(arg);
            } else {
                if ("-?".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    return false;
                }
                if ("-web".equals(arg)) {
                    ++i;
                } else if (arg.startsWith("-")) {
                    if (nextArg == null) {
                        throw new IllegalArgumentException("No value provided for " + arg + " option");
                    }
                    String name = arg.substring(1);
                    String value = nextArg;
                    if ("enc".equals(name)) {
                        this.snuggleOptions.setEncoding(value);
                    } else if ("indent".equals(name)) {
                        this.snuggleOptions.setIndenting(this.parseBoolean(name, value));
                    } else if ("xmldecl".equals(name)) {
                        this.snuggleOptions.setIncludingXMLDeclaration(this.parseBoolean(name, value));
                    } else if ("dtpublic".equals(name)) {
                        this.snuggleOptions.setDoctypePublic(value);
                    } else if ("dtsystem".equals(name)) {
                        this.snuggleOptions.setDoctypeSystem(value);
                    } else if ("ctype".equals(name)) {
                        this.snuggleOptions.setContentType(value);
                    } else if ("lang".equals(name)) {
                        this.snuggleOptions.setLang(value);
                    } else if ("title".equals(name)) {
                        this.snuggleOptions.setTitle(value);
                    } else if ("head".equals(name)) {
                        this.snuggleOptions.setAddingTitleHeading(this.parseBoolean(name, value));
                    } else if ("style".equals(name)) {
                        this.snuggleOptions.setIncludingStyleElement(this.parseBoolean(name, value));
                    } else if ("css".equals(name)) {
                        this.snuggleOptions.addCSSStylesheetURLs(value);
                    } else if ("clientxsl".equals(name)) {
                        this.snuggleOptions.addClientSideXSLTStylesheetURLs(value);
                    } else {
                        throw new IllegalArgumentException("Unknown option " + arg);
                    }
                    ++i;
                } else {
                    this.inputFiles.add(arg);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean parseBoolean(String name, String value) {
        if ("true".equals(value) || "on".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "off".equals(value) || "0".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("Expected option " + name + " to have value true, false, on, off, 1 or 0, but got " + value);
    }

    public static void main(String[] args) {
        new CommandLineRunner(args).execute();
    }
}

