/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.knn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import org.openimaj.knn.CoordinateIndex;
import org.openimaj.knn.CoordinateKDTree;
import org.openimaj.math.geometry.point.Coordinate;

public class CoordinateBruteForce<T extends Coordinate>
implements CoordinateIndex<T> {
    List<T> data = new ArrayList<T>();

    public CoordinateBruteForce() {
    }

    public CoordinateBruteForce(List<T> data) {
        this.data = data;
    }

    @Override
    public void insert(T point) {
        this.data.add(point);
    }

    @Override
    public void rangeSearch(Collection<T> results, Coordinate lowerExtreme, Coordinate upperExtreme) {
        for (Coordinate d : this.data) {
            if (!CoordinateKDTree.isContained(d, lowerExtreme, upperExtreme)) continue;
            results.add(d);
        }
    }

    @Override
    public T nearestNeighbour(Coordinate query) {
        float minDist = Float.MAX_VALUE;
        Coordinate best = null;
        for (Coordinate d : this.data) {
            float dist = CoordinateKDTree.distance(d, query);
            if (!(dist < minDist)) continue;
            minDist = dist;
            best = d;
        }
        return (T)best;
    }

    @Override
    public void kNearestNeighbour(Collection<T> result, Coordinate query, int k) {
        PriorityQueue<Match> queue = new PriorityQueue<Match>(this.data.size());
        for (Coordinate d : this.data) {
            Match m = new Match();
            m.coord = d;
            m.distance = CoordinateKDTree.distance(query, d);
            queue.add(m);
        }
        for (int i = 0; i < k; ++i) {
            result.add(((Match)queue.poll()).coord);
        }
    }

    class Match
    implements Comparable<Match> {
        float distance;
        T coord;

        Match() {
        }

        @Override
        public int compareTo(Match o) {
            if (this.distance > o.distance) {
                return 1;
            }
            if (this.distance < o.distance) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return this.distance + "";
        }
    }
}

