/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.BaseFacebookClient;
import com.restfb.DefaultJsonMapper;
import com.restfb.DefaultWebRequestor;
import com.restfb.JsonMapper;
import com.restfb.LegacyFacebookClient;
import com.restfb.Parameter;
import com.restfb.WebRequestor;
import com.restfb.exception.FacebookJsonMappingException;
import com.restfb.exception.FacebookNetworkException;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonException;
import com.restfb.json.JsonObject;
import com.restfb.util.StringUtils;
import com.restfb.util.UrlUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLegacyFacebookClient
extends BaseFacebookClient
implements LegacyFacebookClient {
    protected String apiKey;
    protected String secretKey;
    protected String accessToken;
    protected static final String FACEBOOK_REST_ENDPOINT_URL = "https://api.facebook.com/restserver.php";
    protected static final String FACEBOOK_READ_ONLY_ENDPOINT_URL = "https://api-read.facebook.com/restserver.php";
    protected static final String METHOD_PARAM_NAME = "method";
    protected static final String FORMAT_PARAM_NAME = "format";
    protected static final String FORMAT_PARAM_VALUE = "json";
    protected static final String API_KEY_PARAM_NAME = "api_key";
    protected static final String CALL_ID_PARAM_NAME = "call_id";
    protected static final String SIG_PARAM_NAME = "sig";
    protected static final String SESSION_KEY_PARAM_NAME = "session_key";
    protected static final String VERSION_PARAM_NAME = "v";
    protected static final String VERSION_PARAM_VALUE = "1.0";

    public DefaultLegacyFacebookClient(String string) {
        this(string, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    @Deprecated
    public DefaultLegacyFacebookClient(String string, String string2) {
        this(string, string2, new DefaultWebRequestor(), new DefaultJsonMapper());
    }

    @Deprecated
    public DefaultLegacyFacebookClient(String string, String string2, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("apiKey", string);
        this.verifyParameterPresence("secretKey", string2);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.apiKey = string.trim();
        this.secretKey = string2.trim();
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.initializeIllegalParamNames();
    }

    public DefaultLegacyFacebookClient(String string, WebRequestor webRequestor, JsonMapper jsonMapper) {
        this.verifyParameterPresence("accessToken", string);
        this.verifyParameterPresence("webRequestor", webRequestor);
        this.verifyParameterPresence("jsonMapper", jsonMapper);
        this.accessToken = string.trim();
        this.webRequestor = webRequestor;
        this.jsonMapper = jsonMapper;
        this.initializeIllegalParamNames();
    }

    @Override
    public void execute(String string, Parameter ... parameterArray) {
        this.execute(string, (String)null, parameterArray);
    }

    @Override
    public void execute(String string, String string2, Parameter ... parameterArray) {
        this.makeRequest(string, string2, parameterArray);
    }

    @Override
    public <T> T execute(String string, Class<T> clazz, Parameter ... parameterArray) {
        return this.execute(string, null, clazz, parameterArray);
    }

    @Override
    public <T> T execute(String string, String string2, Class<T> clazz, Parameter ... parameterArray) {
        return this.jsonMapper.toJavaObject(this.makeRequest(string, string2, parameterArray), clazz);
    }

    @Override
    public <T> List<T> executeForList(String string, Class<T> clazz, Parameter ... parameterArray) {
        return this.executeForList(string, null, clazz, parameterArray);
    }

    @Override
    public <T> List<T> executeForList(String string, String string2, Class<T> clazz, Parameter ... parameterArray) {
        return this.jsonMapper.toJavaList(this.makeRequest(string, string2, parameterArray), clazz);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> map, Class<T> clazz, Parameter ... parameterArray) {
        return this.executeMultiquery(map, clazz, parameterArray);
    }

    @Override
    public <T> T executeMultiquery(Map<String, String> map, String string, Class<T> clazz, Parameter ... parameterArray) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        arrayList.add(Parameter.with("queries", this.queriesToJson(map)));
        for (Parameter object : parameterArray) {
            if (object.name.equals("queries")) {
                throw new IllegalArgumentException("You cannot specify a parameter named 'queries' because it's reserved for use by RestFB for this call. Specify your queries in the Map that gets passed to this method.");
            }
            arrayList.add(object);
        }
        JsonObject jsonObject = new JsonObject();
        try {
            JsonArray jsonArray = new JsonArray(this.makeRequest("fql.multiquery", string, arrayList.toArray(new Parameter[0])));
            for (int i = 0; i < jsonArray.length(); ++i) {
                JsonObject jsonObject2 = jsonArray.getJsonObject(i);
                JsonArray jsonArray2 = jsonObject2.get("fql_result_set") instanceof JsonArray ? jsonObject2.getJsonArray("fql_result_set") : new JsonArray();
                jsonObject.put(jsonObject2.getString("name"), jsonArray2);
            }
        }
        catch (JsonException jsonException) {
            throw new FacebookJsonMappingException("Unable to process fql.multiquery JSON response", jsonException);
        }
        return this.jsonMapper.toJavaObject(jsonObject.toString(), clazz);
    }

    protected String makeRequest(String string, String string2, Parameter ... parameterArray) {
        this.verifyParameterLegality(parameterArray);
        String string3 = this.toParameterString(string, string2, parameterArray);
        WebRequestor.Response response = null;
        try {
            response = this.webRequestor.executePost(this.createEndpointForApiCall(string, false), string3);
        }
        catch (Throwable throwable) {
            throw new FacebookNetworkException("Facebook POST failed", throwable);
        }
        if (200 != response.getStatusCode()) {
            throw new FacebookNetworkException("Facebook POST failed", response.getStatusCode());
        }
        String string4 = response.getBody();
        this.throwLegacyFacebookResponseStatusExceptionIfNecessary(string4, response.getStatusCode());
        return string4;
    }

    protected String toParameterString(String string, String string2, Parameter ... parameterArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Parameter object : parameterArray) {
            treeMap.put(object.name, object.value);
        }
        treeMap.put(FORMAT_PARAM_NAME, FORMAT_PARAM_VALUE);
        treeMap.put(METHOD_PARAM_NAME, string);
        if (this.usesAccessTokenAuthentication()) {
            if (string2 != null) {
                throw new IllegalArgumentException("If you're using the OAuth access token for authentication, you cannot specify a session key.");
            }
            treeMap.put("access_token", this.accessToken);
        } else {
            treeMap.put(API_KEY_PARAM_NAME, this.apiKey);
            treeMap.put(VERSION_PARAM_NAME, VERSION_PARAM_VALUE);
            treeMap.put(CALL_ID_PARAM_NAME, String.valueOf(System.currentTimeMillis()));
            if (!StringUtils.isBlank(string2)) {
                treeMap.put(SESSION_KEY_PARAM_NAME, string2);
            }
            treeMap.put(SIG_PARAM_NAME, this.generateSignature(treeMap));
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (n != 0) {
                n = 0;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(UrlUtils.urlEncode((String)entry.getKey()));
            stringBuilder.append("=");
            stringBuilder.append(this.usesAccessTokenAuthentication() ? this.urlEncodedValueForParameterName((String)entry.getKey(), (String)entry.getValue()) : UrlUtils.urlEncode((String)entry.getValue()));
        }
        return stringBuilder.toString();
    }

    protected String generateSignature(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        stringBuilder.append(this.secretKey);
        return this.generateMd5(stringBuilder.toString());
    }

    protected String generateMd5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = StringUtils.toBytes(string);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : messageDigest.digest(byArray)) {
                stringBuilder.append(Integer.toHexString((by & 0xF0) >>> 4));
                stringBuilder.append(Integer.toHexString(by & 0xF));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MD5 isn't available on this JVM", noSuchAlgorithmException);
        }
    }

    protected boolean usesAccessTokenAuthentication() {
        return !StringUtils.isBlank(this.accessToken);
    }

    @Override
    protected String createEndpointForApiCall(String string, boolean bl) {
        return this.readOnlyApiCalls.contains(string = StringUtils.trimToEmpty(string).toLowerCase()) ? this.getFacebookReadOnlyEndpointUrl() : this.getFacebookRestEndpointUrl();
    }

    protected void initializeIllegalParamNames() {
        this.illegalParamNames.addAll(Arrays.asList(API_KEY_PARAM_NAME, CALL_ID_PARAM_NAME, SIG_PARAM_NAME, METHOD_PARAM_NAME, SESSION_KEY_PARAM_NAME, FORMAT_PARAM_NAME, VERSION_PARAM_NAME, "access_token"));
    }

    protected String getFacebookRestEndpointUrl() {
        return FACEBOOK_REST_ENDPOINT_URL;
    }

    @Override
    protected String getFacebookReadOnlyEndpointUrl() {
        return FACEBOOK_READ_ONLY_ENDPOINT_URL;
    }
}

