/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.geo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;
import org.openimaj.text.geo.WorldPlace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WorldPolygons {
    private static Document doc;
    private Map<String, WorldPlace> countryShapes = new HashMap<String, WorldPlace>();
    private Map<String, WorldPlace> countryCodeShapes = new HashMap<String, WorldPlace>();
    private Rectangle bounds;

    public WorldPolygons() {
        doc.getDocumentElement().normalize();
        NodeList places = doc.getElementsByTagName("Placemark");
        float minx = 2.1474836E9f;
        float miny = 2.1474836E9f;
        float maxx = -2.1474836E9f;
        float maxy = -2.1474836E9f;
        for (int i = 0; i < places.getLength(); ++i) {
            Node placeNode = places.item(i);
            String name = this.getNodeValue(placeNode, "name");
            String desc = this.getNodeValue(placeNode, "description");
            String countryCode = desc.split(":")[0].split("=")[1].trim().toLowerCase();
            Node lookat = this.getFirstNode(placeNode, "LookAt");
            String latStr = this.getNodeValue(lookat, "latitude");
            String lonStr = this.getNodeValue(lookat, "longitude");
            Element multiGeom = (Element)this.getFirstNode(placeNode, "MultiGeometry");
            NodeList polygonNodes = multiGeom.getElementsByTagName("Polygon");
            ArrayList<Shape> polygons = new ArrayList<Shape>();
            for (int j = 0; j < polygonNodes.getLength(); ++j) {
                String[] coords = this.getNodeValue(polygonNodes.item(j), "coordinates").split(" ");
                ArrayList<Point2dImpl> points = new ArrayList<Point2dImpl>();
                for (String coord : coords) {
                    String[] xy = coord.split(",");
                    float fx = Float.parseFloat(xy[0]);
                    float fy = Float.parseFloat(xy[1]);
                    minx = Math.min(minx, fx);
                    miny = Math.min(miny, fy);
                    maxx = Math.max(maxx, fx);
                    maxy = Math.max(maxy, fy);
                    points.add(new Point2dImpl(fx, fy));
                }
                polygons.add((Shape)new Polygon(points));
            }
            WorldPlace place = new WorldPlace(name, countryCode, Float.parseFloat(latStr), Float.parseFloat(lonStr), polygons);
            this.countryShapes.put(name, place);
            this.countryCodeShapes.put(countryCode, place);
        }
        this.bounds = new Rectangle(minx, miny, maxx - minx, maxy - miny);
    }

    private String getNodeValue(Node node, String nodeName) {
        Node firstNode = this.getFirstNode(node, nodeName);
        return firstNode.getFirstChild().getNodeValue();
    }

    private Node getFirstNode(Node node, String nodeName) {
        return ((Element)node).getElementsByTagName(nodeName).item(0);
    }

    public Collection<WorldPlace> getShapes() {
        return this.countryShapes.values();
    }

    public WorldPlace byCountryCode(String countryCode) {
        return this.countryCodeShapes.get(countryCode.toLowerCase());
    }

    public WorldPlace byCountry(String country) {
        return this.countryShapes.get(country);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(WorldPolygons.class.getResourceAsStream("countries_world.kml"));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }
}

