/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.geo;

import java.util.List;
import org.openimaj.math.geometry.shape.Shape;

public class WorldPlace {
    private String countryCode;
    private String name;
    private List<Shape> geoms;
    private float lat;
    private float lon;

    public WorldPlace(String name, String countryCode, float lat, float lon, List<Shape> shape) {
        this.name = name;
        this.countryCode = countryCode;
        this.lat = lat;
        this.lon = lon;
        this.geoms = shape;
    }

    public String toString() {
        return String.format("{%s: (%2.2f,%2.2f), Area: %s}", this.name, Float.valueOf(this.lat), Float.valueOf(this.lon), this.calculateArea());
    }

    public double calculateArea() {
        double total = 0.0;
        for (Shape geom : this.geoms) {
            total += geom.calculateArea();
        }
        return total;
    }

    public List<Shape> getShapes() {
        return this.geoms;
    }

    public String getISOA2() {
        return this.countryCode;
    }
}

