/*
 * Decompiled with CFR 0.152.
 */
package org.oc.ocvolume.dsp;

import org.oc.ocvolume.dsp.fft;

public class featureExtraction {
    protected static final int frameLength = 512;
    protected static final int shiftInterval = 256;
    public int numCepstra = 13;
    protected static final int fftSize = 512;
    protected static final double preEmphasisAlpha = 0.95;
    protected static final double lowerFilterFreq = 133.3334;
    protected static final double upperFilterFreq = 6855.4976;
    protected static final int numMelFilters = 23;
    protected double[][] frames;
    protected double[] hammingWindow;
    protected fft FFT;

    public double[][] process(short[] inputSignal, double samplingRate) {
        double[] outputSignal = featureExtraction.preEmphasis(inputSignal);
        this.framing(outputSignal);
        double[][] MFCC2 = new double[this.frames.length][this.numCepstra];
        this.hammingWindow();
        int k = 0;
        while (k < this.frames.length) {
            this.FFT = new fft();
            double[] bin = this.magnitudeSpectrum(this.frames[k]);
            int[] cbin = this.fftBinIndices(samplingRate, 512);
            double[] fbank = this.melFilter(bin, cbin);
            double[] f = this.nonLinearTransformation(fbank);
            double[] cepc = this.cepCoefficients(f);
            int i = 0;
            while (i < this.numCepstra) {
                MFCC2[k][i] = cepc[i];
                ++i;
            }
            ++k;
        }
        return MFCC2;
    }

    public int[] fftBinIndices(double samplingRate, int frameSize) {
        int[] cbin = new int[25];
        cbin[0] = (int)Math.round(133.3334 / samplingRate * (double)frameSize);
        cbin[cbin.length - 1] = frameSize / 2;
        int i = 1;
        while (i <= 23) {
            double fc = featureExtraction.centerFreq(i, samplingRate);
            cbin[i] = (int)Math.round(fc / samplingRate * (double)frameSize);
            ++i;
        }
        return cbin;
    }

    public double[] melFilter(double[] bin, int[] cbin) {
        double[] temp = new double[25];
        int k = 1;
        while (k <= 23) {
            double num1 = 0.0;
            double num2 = 0.0;
            int i = cbin[k - 1];
            while (i <= cbin[k]) {
                num1 += (double)((i - cbin[k - 1] + 1) / (cbin[k] - cbin[k - 1] + 1)) * bin[i];
                ++i;
            }
            i = cbin[k] + 1;
            while (i <= cbin[k + 1]) {
                num2 += (double)(1 - (i - cbin[k]) / (cbin[k + 1] - cbin[k] + 1)) * bin[i];
                ++i;
            }
            temp[k] = num1 + num2;
            ++k;
        }
        double[] fbank = new double[23];
        int i = 0;
        while (i < 23) {
            fbank[i] = temp[i + 1];
            ++i;
        }
        return fbank;
    }

    public double[] cepCoefficients(double[] f) {
        double[] cepc = new double[this.numCepstra];
        int i = 0;
        while (i < cepc.length) {
            int j = 1;
            while (j <= 23) {
                int n = i;
                cepc[n] = cepc[n] + f[j - 1] * Math.cos(Math.PI * (double)i / 23.0 * ((double)j - 0.5));
                ++j;
            }
            ++i;
        }
        return cepc;
    }

    public double[] nonLinearTransformation(double[] fbank) {
        double[] f = new double[fbank.length];
        double FLOOR = -50.0;
        int i = 0;
        while (i < fbank.length) {
            f[i] = Math.log(fbank[i]);
            if (f[i] < -50.0) {
                f[i] = -50.0;
            }
            ++i;
        }
        return f;
    }

    protected static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    private static double centerFreq(int i, double samplingRate) {
        double[] mel = new double[]{featureExtraction.freqToMel(133.3334), featureExtraction.freqToMel(samplingRate / 2.0)};
        double temp = mel[0] + (mel[1] - mel[0]) / 24.0 * (double)i;
        return featureExtraction.inverseMel(temp);
    }

    private static double inverseMel(double x) {
        double temp = Math.pow(10.0, x / 2595.0) - 1.0;
        return 700.0 * temp;
    }

    protected static double freqToMel(double freq) {
        return 2595.0 * featureExtraction.log10(1.0 + freq / 700.0);
    }

    public double[] magnitudeSpectrum(double[] frame) {
        double[] magSpectrum = new double[frame.length];
        fft.computeFFT(frame);
        int k = 0;
        while (k < frame.length) {
            magSpectrum[k] = Math.pow(fft.real[k] * fft.real[k] + fft.imag[k] * fft.imag[k], 0.5);
            ++k;
        }
        return magSpectrum;
    }

    private void hammingWindow() {
        double[] w = new double[512];
        int n = 0;
        while (n < 512) {
            w[n] = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)n / 511.0);
            ++n;
        }
        int m = 0;
        while (m < this.frames.length) {
            int n2 = 0;
            while (n2 < 512) {
                double[] dArray = this.frames[m];
                int n3 = n2;
                dArray[n3] = dArray[n3] * w[n2];
                ++n2;
            }
            ++m;
        }
    }

    protected void framing(double[] inputSignal) {
        double numFrames = (double)inputSignal.length / 256.0;
        if (numFrames / (double)((int)numFrames) != 1.0) {
            numFrames = (int)numFrames + 1;
        }
        double[] paddedSignal = new double[(int)numFrames * 512];
        int n = 0;
        while (n < inputSignal.length) {
            paddedSignal[n] = inputSignal[n];
            ++n;
        }
        this.frames = new double[(int)numFrames][512];
        int m = 0;
        while ((double)m < numFrames) {
            int n2 = 0;
            while (n2 < 512) {
                this.frames[m][n2] = paddedSignal[m * 256 + n2];
                ++n2;
            }
            ++m;
        }
    }

    protected static double[] preEmphasis(short[] inputSignal) {
        double[] outputSignal = new double[inputSignal.length];
        int n = 1;
        while (n < inputSignal.length) {
            outputSignal[n] = (double)inputSignal[n] - 0.95 * (double)inputSignal[n - 1];
            ++n;
        }
        return outputSignal;
    }
}

