/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp.file;

import java.io.File;
import java.io.FileFilter;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.multihelp.HelpViewer;
import org.multihelp.file.FileNode;

public class JavadocFile
extends FileNode {
    private static final long serialVersionUID = 2L;
    private Icon icon = null;
    private String packageName = "";
    private String text = "";
    private File fileLocation;
    private Filter filter = new Filter();
    boolean isDirectory;

    public JavadocFile(File file) {
        super(file);
        this.fileLocation = file;
        if (file.getName().endsWith(".html")) {
            this.isDirectory = false;
            this.icon = new ImageIcon("icons/javadoc.png");
            if (this.icon == null) {
                System.out.println("Can not find help/javadoc.png");
            }
            this.text = file.getName().substring(0, file.getName().lastIndexOf(".html"));
        } else {
            this.isDirectory = true;
            this.text = file.getName();
        }
    }

    @Override
    public void setPage(HelpViewer viewer) {
        block6: {
            try {
                if (this.isDirectory) {
                    File loc = new File(String.valueOf(this.fileLocation.getCanonicalPath()) + File.separator + "index.html");
                    if (loc.exists()) {
                        viewer.setPage(loc.toURI().toURL());
                        break block6;
                    }
                    System.out.println(String.valueOf(loc.getCanonicalPath()) + " not found.");
                    HTMLDocument doc = new HTMLDocument();
                    try {
                        doc.insertString(0, this.generateDefaultIndex(), null);
                        doc.setBase(this.fileLocation.toURI().toURL());
                    }
                    catch (BadLocationException e) {
                        Logger.getLogger(this.getClass().getCanonicalName());
                    }
                    viewer.setContentType("text/html");
                    viewer.setDocument(doc);
                    break block6;
                }
                viewer.setPage(this.fileLocation.toURI().toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getStackTrace(), "ERROR", 0);
            }
        }
    }

    protected String generateDefaultIndex() {
        if (this.fileLocation.isDirectory() && this.fileLocation.listFiles().length > 0) {
            File[] list = this.fileLocation.listFiles();
            StringBuffer ret = new StringBuffer("<html><body><ul>");
            int i = 0;
            while (i < list.length) {
                ret.append("<li><a href=\"" + list[i].getName() + "\">" + list[i].getName() + "</a></li>");
                ++i;
            }
            ret.append("<ul></body></html>");
            return ret.toString();
        }
        if (this.fileLocation.isDirectory()) {
            return "<html><body>ERROR: Empty directory in the help system.</body></html>";
        }
        return "<html><body>INTERNAL ERROR: Loading non-existant file</body></html>";
    }

    @Override
    public void traverseFileSystem(File root, int depth) {
        File[] children;
        if (depth < 512 && (children = root.listFiles()) != null && children.length != 0) {
            int i = 0;
            while (i < children.length) {
                if (this.filter.accept(children[i])) {
                    JavadocFile childNode = new JavadocFile(children[i]);
                    this.add(childNode);
                    childNode.setParent(this);
                    childNode.traverseFileSystem(children[i], depth + 1);
                }
                ++i;
            }
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public class Filter
    implements FileFilter {
        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (pathname.getName().endsWith(".html") || pathname.getName().endsWith(".htm")) {
                if (pathname.getName().contentEquals("index.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("index.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("allclasses-frame.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("allclasses-noframe.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("constant-values.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("deprecated-list.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("index-all.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("overview-frame.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("overview-summary.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("overview-tree.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("package-frame.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("package-list.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("package-summary.html")) {
                    return false;
                }
                if (pathname.getName().contentEquals("package-tree.html")) {
                    return false;
                }
                return !pathname.getName().contentEquals("serialized-form.html");
            }
            return false;
        }
    }
}

