/*
 * Decompiled with CFR 0.152.
 */
package org.multihelp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.multihelp.FileTreeReader;
import org.multihelp.HelpViewer;

public class HelpWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private FileTreeReader leftPane;
    private HelpViewer rightPane;

    public HelpWindow() {
        this.createWindow(new ImageIcon("icons/MultiHelp16.png").getImage(), Locale.getDefault());
    }

    public HelpWindow(Image image) {
        this.createWindow(image, Locale.getDefault());
    }

    public HelpWindow(Locale locale) {
        this.createWindow(new ImageIcon("icons/MultiHelp16.png").getImage(), locale);
    }

    public HelpWindow(Image image, Locale locale) {
        this.createWindow(image, locale);
    }

    protected void createWindow(Image image, Locale locale) {
        if (locale == null) {
            System.out.println("Null locale- 'help'");
            this.leftPane = new FileTreeReader(new File("help"));
        } else {
            File base = new File("help" + File.separator + locale);
            System.out.println("'" + base.getAbsolutePath() + "'");
            if (base.exists()) {
                this.leftPane = new FileTreeReader(base);
            } else {
                System.out.println("base did not exists. using help");
                this.leftPane = new FileTreeReader(new File("help"));
            }
        }
        this.rightPane = new HelpViewer(this.leftPane);
        JScrollPane rightScroll = new JScrollPane();
        rightScroll.setPreferredSize(new Dimension(600, 400));
        rightScroll.getViewport().add(this.rightPane);
        JSplitPane core = new JSplitPane(1, true);
        Container root = this.getContentPane();
        root.add((Component)core, "Center");
        JScrollPane leftScroll = new JScrollPane();
        leftScroll.setPreferredSize(new Dimension(200, 400));
        leftScroll.getViewport().add(this.leftPane);
        core.setLeftComponent(leftScroll);
        core.setRightComponent(rightScroll);
        this.pack();
        this.setVisible(true);
    }
}

